package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupBuilder extends GroupFluent<GroupBuilder> implements VisitableBuilder<Group,GroupBuilder>{
  public GroupBuilder() {
    this(false);
  }
  public GroupBuilder(Boolean validationEnabled) {
    this(new Group(), validationEnabled);
  }
  public GroupBuilder(GroupFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupBuilder(GroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Group(), validationEnabled);
  }
  public GroupBuilder(GroupFluent<?> fluent,Group instance) {
    this(fluent, instance, false);
  }
  public GroupBuilder(GroupFluent<?> fluent,Group instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Group());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withUsers(instance.getUsers());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withUsers(instance.getUsers());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupBuilder(Group instance) {
    this(instance,false);
  }
  public GroupBuilder(Group instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Group());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withUsers(instance.getUsers());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withUsers(instance.getUsers());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupFluent<?> fluent;
  Boolean validationEnabled;
  public Group build() {
    Group buildable = new Group(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.getUsers());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}