package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageManifestBuilder extends ImageManifestFluent<ImageManifestBuilder> implements VisitableBuilder<ImageManifest,ImageManifestBuilder>{
  public ImageManifestBuilder() {
    this(false);
  }
  public ImageManifestBuilder(Boolean validationEnabled) {
    this(new ImageManifest(), validationEnabled);
  }
  public ImageManifestBuilder(ImageManifestFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageManifestBuilder(ImageManifestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageManifest(), validationEnabled);
  }
  public ImageManifestBuilder(ImageManifestFluent<?> fluent,ImageManifest instance) {
    this(fluent, instance, false);
  }
  public ImageManifestBuilder(ImageManifestFluent<?> fluent,ImageManifest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageManifest());

    if (instance != null) {
      fluent.withArchitecture(instance.getArchitecture());
      fluent.withDigest(instance.getDigest());
      fluent.withManifestSize(instance.getManifestSize());
      fluent.withMediaType(instance.getMediaType());
      fluent.withOs(instance.getOs());
      fluent.withVariant(instance.getVariant());
      fluent.withArchitecture(instance.getArchitecture());
      fluent.withDigest(instance.getDigest());
      fluent.withManifestSize(instance.getManifestSize());
      fluent.withMediaType(instance.getMediaType());
      fluent.withOs(instance.getOs());
      fluent.withVariant(instance.getVariant());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageManifestBuilder(ImageManifest instance) {
    this(instance,false);
  }
  public ImageManifestBuilder(ImageManifest instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageManifest());

    if (instance != null) {
      this.withArchitecture(instance.getArchitecture());
      this.withDigest(instance.getDigest());
      this.withManifestSize(instance.getManifestSize());
      this.withMediaType(instance.getMediaType());
      this.withOs(instance.getOs());
      this.withVariant(instance.getVariant());
      this.withArchitecture(instance.getArchitecture());
      this.withDigest(instance.getDigest());
      this.withManifestSize(instance.getManifestSize());
      this.withMediaType(instance.getMediaType());
      this.withOs(instance.getOs());
      this.withVariant(instance.getVariant());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageManifestFluent<?> fluent;
  Boolean validationEnabled;
  public ImageManifest build() {
    ImageManifest buildable = new ImageManifest(fluent.getArchitecture(),fluent.getDigest(),fluent.getManifestSize(),fluent.getMediaType(),fluent.getOs(),fluent.getVariant());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}