package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSourceBuilder extends ImageSourceFluent<ImageSourceBuilder> implements VisitableBuilder<ImageSource,ImageSourceBuilder>{
  public ImageSourceBuilder() {
    this(false);
  }
  public ImageSourceBuilder(Boolean validationEnabled) {
    this(new ImageSource(), validationEnabled);
  }
  public ImageSourceBuilder(ImageSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSourceBuilder(ImageSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageSource(), validationEnabled);
  }
  public ImageSourceBuilder(ImageSourceFluent<?> fluent,ImageSource instance) {
    this(fluent, instance, false);
  }
  public ImageSourceBuilder(ImageSourceFluent<?> fluent,ImageSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageSource());

    if (instance != null) {
      fluent.withAs(instance.getAs());
      fluent.withFrom(instance.getFrom());
      fluent.withPaths(instance.getPaths());
      fluent.withPullSecret(instance.getPullSecret());
      fluent.withAs(instance.getAs());
      fluent.withFrom(instance.getFrom());
      fluent.withPaths(instance.getPaths());
      fluent.withPullSecret(instance.getPullSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageSourceBuilder(ImageSource instance) {
    this(instance,false);
  }
  public ImageSourceBuilder(ImageSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageSource());

    if (instance != null) {
      this.withAs(instance.getAs());
      this.withFrom(instance.getFrom());
      this.withPaths(instance.getPaths());
      this.withPullSecret(instance.getPullSecret());
      this.withAs(instance.getAs());
      this.withFrom(instance.getFrom());
      this.withPaths(instance.getPaths());
      this.withPullSecret(instance.getPullSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ImageSource build() {
    ImageSource buildable = new ImageSource(fluent.getAs(),fluent.buildFrom(),fluent.buildPaths(),fluent.buildPullSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}