package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImportSpecBuilder extends ImageStreamImportSpecFluent<ImageStreamImportSpecBuilder> implements VisitableBuilder<ImageStreamImportSpec,ImageStreamImportSpecBuilder>{
  public ImageStreamImportSpecBuilder() {
    this(false);
  }
  public ImageStreamImportSpecBuilder(Boolean validationEnabled) {
    this(new ImageStreamImportSpec(), validationEnabled);
  }
  public ImageStreamImportSpecBuilder(ImageStreamImportSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImportSpecBuilder(ImageStreamImportSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamImportSpec(), validationEnabled);
  }
  public ImageStreamImportSpecBuilder(ImageStreamImportSpecFluent<?> fluent,ImageStreamImportSpec instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImportSpecBuilder(ImageStreamImportSpecFluent<?> fluent,ImageStreamImportSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageStreamImportSpec());

    if (instance != null) {
      fluent.withImages(instance.getImages());
      fluent.withImport(instance.getImport());
      fluent.withRepository(instance.getRepository());
      fluent.withImages(instance.getImages());
      fluent.withImport(instance.getImport());
      fluent.withRepository(instance.getRepository());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImportSpecBuilder(ImageStreamImportSpec instance) {
    this(instance,false);
  }
  public ImageStreamImportSpecBuilder(ImageStreamImportSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageStreamImportSpec());

    if (instance != null) {
      this.withImages(instance.getImages());
      this.withImport(instance.getImport());
      this.withRepository(instance.getRepository());
      this.withImages(instance.getImages());
      this.withImport(instance.getImport());
      this.withRepository(instance.getRepository());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamImportSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamImportSpec build() {
    ImageStreamImportSpec buildable = new ImageStreamImportSpec(fluent.buildImages(),fluent.getImport(),fluent.buildRepository());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}