package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicySubjectReviewBuilder extends PodSecurityPolicySubjectReviewFluent<PodSecurityPolicySubjectReviewBuilder> implements VisitableBuilder<PodSecurityPolicySubjectReview,PodSecurityPolicySubjectReviewBuilder>{
  public PodSecurityPolicySubjectReviewBuilder() {
    this(false);
  }
  public PodSecurityPolicySubjectReviewBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicySubjectReview(), validationEnabled);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicySubjectReview(), validationEnabled);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,PodSecurityPolicySubjectReview instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReviewFluent<?> fluent,PodSecurityPolicySubjectReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSecurityPolicySubjectReview());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReview instance) {
    this(instance,false);
  }
  public PodSecurityPolicySubjectReviewBuilder(PodSecurityPolicySubjectReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSecurityPolicySubjectReview());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicySubjectReviewFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicySubjectReview build() {
    PodSecurityPolicySubjectReview buildable = new PodSecurityPolicySubjectReview(fluent.getApiVersion(),fluent.getKind(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}