package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaStatusByNamespaceBuilder extends ResourceQuotaStatusByNamespaceFluent<ResourceQuotaStatusByNamespaceBuilder> implements VisitableBuilder<ResourceQuotaStatusByNamespace,ResourceQuotaStatusByNamespaceBuilder>{
  public ResourceQuotaStatusByNamespaceBuilder() {
    this(false);
  }
  public ResourceQuotaStatusByNamespaceBuilder(Boolean validationEnabled) {
    this(new ResourceQuotaStatusByNamespace(), validationEnabled);
  }
  public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceQuotaStatusByNamespace(), validationEnabled);
  }
  public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent,ResourceQuotaStatusByNamespace instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespaceFluent<?> fluent,ResourceQuotaStatusByNamespace instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceQuotaStatusByNamespace());

    if (instance != null) {
      fluent.withNamespace(instance.getNamespace());
      fluent.withStatus(instance.getStatus());
      fluent.withNamespace(instance.getNamespace());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespace instance) {
    this(instance,false);
  }
  public ResourceQuotaStatusByNamespaceBuilder(ResourceQuotaStatusByNamespace instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceQuotaStatusByNamespace());

    if (instance != null) {
      this.withNamespace(instance.getNamespace());
      this.withStatus(instance.getStatus());
      this.withNamespace(instance.getNamespace());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceQuotaStatusByNamespaceFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceQuotaStatusByNamespace build() {
    ResourceQuotaStatusByNamespace buildable = new ResourceQuotaStatusByNamespace(fluent.getNamespace(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}