package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleListBuilder extends RoleListFluent<RoleListBuilder> implements VisitableBuilder<RoleList,RoleListBuilder>{
  public RoleListBuilder() {
    this(false);
  }
  public RoleListBuilder(Boolean validationEnabled) {
    this(new RoleList(), validationEnabled);
  }
  public RoleListBuilder(RoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleListBuilder(RoleListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RoleList(), validationEnabled);
  }
  public RoleListBuilder(RoleListFluent<?> fluent,RoleList instance) {
    this(fluent, instance, false);
  }
  public RoleListBuilder(RoleListFluent<?> fluent,RoleList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RoleList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RoleListBuilder(RoleList instance) {
    this(instance,false);
  }
  public RoleListBuilder(RoleList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RoleList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RoleListFluent<?> fluent;
  Boolean validationEnabled;
  public RoleList build() {
    RoleList buildable = new RoleList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}