package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretSpecBuilder extends SecretSpecFluent<SecretSpecBuilder> implements VisitableBuilder<SecretSpec,SecretSpecBuilder>{
  public SecretSpecBuilder() {
    this(false);
  }
  public SecretSpecBuilder(Boolean validationEnabled) {
    this(new SecretSpec(), validationEnabled);
  }
  public SecretSpecBuilder(SecretSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretSpecBuilder(SecretSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretSpec(), validationEnabled);
  }
  public SecretSpecBuilder(SecretSpecFluent<?> fluent,SecretSpec instance) {
    this(fluent, instance, false);
  }
  public SecretSpecBuilder(SecretSpecFluent<?> fluent,SecretSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SecretSpec());

    if (instance != null) {
      fluent.withMountPath(instance.getMountPath());
      fluent.withSecretSource(instance.getSecretSource());
      fluent.withMountPath(instance.getMountPath());
      fluent.withSecretSource(instance.getSecretSource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretSpecBuilder(SecretSpec instance) {
    this(instance,false);
  }
  public SecretSpecBuilder(SecretSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SecretSpec());

    if (instance != null) {
      this.withMountPath(instance.getMountPath());
      this.withSecretSource(instance.getSecretSource());
      this.withMountPath(instance.getMountPath());
      this.withSecretSource(instance.getSecretSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SecretSpec build() {
    SecretSpec buildable = new SecretSpec(fluent.getMountPath(),fluent.buildSecretSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}