package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagEventBuilder extends TagEventFluent<TagEventBuilder> implements VisitableBuilder<TagEvent,TagEventBuilder>{
  public TagEventBuilder() {
    this(false);
  }
  public TagEventBuilder(Boolean validationEnabled) {
    this(new TagEvent(), validationEnabled);
  }
  public TagEventBuilder(TagEventFluent<?> fluent) {
    this(fluent, false);
  }
  public TagEventBuilder(TagEventFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TagEvent(), validationEnabled);
  }
  public TagEventBuilder(TagEventFluent<?> fluent,TagEvent instance) {
    this(fluent, instance, false);
  }
  public TagEventBuilder(TagEventFluent<?> fluent,TagEvent instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TagEvent());

    if (instance != null) {
      fluent.withCreated(instance.getCreated());
      fluent.withDockerImageReference(instance.getDockerImageReference());
      fluent.withGeneration(instance.getGeneration());
      fluent.withImage(instance.getImage());
      fluent.withCreated(instance.getCreated());
      fluent.withDockerImageReference(instance.getDockerImageReference());
      fluent.withGeneration(instance.getGeneration());
      fluent.withImage(instance.getImage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TagEventBuilder(TagEvent instance) {
    this(instance,false);
  }
  public TagEventBuilder(TagEvent instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TagEvent());

    if (instance != null) {
      this.withCreated(instance.getCreated());
      this.withDockerImageReference(instance.getDockerImageReference());
      this.withGeneration(instance.getGeneration());
      this.withImage(instance.getImage());
      this.withCreated(instance.getCreated());
      this.withDockerImageReference(instance.getDockerImageReference());
      this.withGeneration(instance.getGeneration());
      this.withImage(instance.getImage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TagEventFluent<?> fluent;
  Boolean validationEnabled;
  public TagEvent build() {
    TagEvent buildable = new TagEvent(fluent.getCreated(),fluent.getDockerImageReference(),fluent.getGeneration(),fluent.getImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}