package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UserIdentityMappingFluent<A extends UserIdentityMappingFluent<A>> extends BaseFluent<A>{
  public UserIdentityMappingFluent() {
  }
  public UserIdentityMappingFluent(UserIdentityMapping instance) {
    instance = (instance != null ? instance : new UserIdentityMapping());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withIdentity(instance.getIdentity());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withUser(instance.getUser());
      this.withApiVersion(instance.getApiVersion());
      this.withIdentity(instance.getIdentity());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ObjectReferenceBuilder identity;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ObjectReferenceBuilder user;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public ObjectReference buildIdentity() {
    return this.identity!=null ?this.identity.build():null;
  }
  public A withIdentity(ObjectReference identity) {
    _visitables.get("identity").remove(this.identity);
    if (identity!=null){ this.identity= new ObjectReferenceBuilder(identity); _visitables.get("identity").add(this.identity);} else { this.identity = null; _visitables.get("identity").remove(this.identity); } return (A) this;
  }
  public boolean hasIdentity() {
    return this.identity != null;
  }
  public IdentityNested<A> withNewIdentity() {
    return new IdentityNested(null);
  }
  public IdentityNested<A> withNewIdentityLike(ObjectReference item) {
    return new IdentityNested(item);
  }
  public IdentityNested<A> editIdentity() {
    return withNewIdentityLike(java.util.Optional.ofNullable(buildIdentity()).orElse(null));
  }
  public IdentityNested<A> editOrNewIdentity() {
    return withNewIdentityLike(java.util.Optional.ofNullable(buildIdentity()).orElse(new ObjectReferenceBuilder().build()));
  }
  public IdentityNested<A> editOrNewIdentityLike(ObjectReference item) {
    return withNewIdentityLike(java.util.Optional.ofNullable(buildIdentity()).orElse(item));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public ObjectReference buildUser() {
    return this.user!=null ?this.user.build():null;
  }
  public A withUser(ObjectReference user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new ObjectReferenceBuilder(user); _visitables.get("user").add(this.user);} else { this.user = null; _visitables.get("user").remove(this.user); } return (A) this;
  }
  public boolean hasUser() {
    return this.user != null;
  }
  public UserNested<A> withNewUser() {
    return new UserNested(null);
  }
  public UserNested<A> withNewUserLike(ObjectReference item) {
    return new UserNested(item);
  }
  public UserNested<A> editUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(null));
  }
  public UserNested<A> editOrNewUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(new ObjectReferenceBuilder().build()));
  }
  public UserNested<A> editOrNewUserLike(ObjectReference item) {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    UserIdentityMappingFluent that = (UserIdentityMappingFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(identity, that.identity)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(user, that.user)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  identity,  kind,  metadata,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (identity != null) { sb.append("identity:"); sb.append(identity + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IdentityNested<N> extends ObjectReferenceFluent<IdentityNested<N>> implements Nested<N>{
    IdentityNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) UserIdentityMappingFluent.this.withIdentity(builder.build());
    }
    public N endIdentity() {
      return and();
    }
    
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) UserIdentityMappingFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class UserNested<N> extends ObjectReferenceFluent<UserNested<N>> implements Nested<N>{
    UserNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) UserIdentityMappingFluent.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}