package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildStatusBuilder extends BuildStatusFluent<BuildStatusBuilder> implements VisitableBuilder<BuildStatus,BuildStatusBuilder>{
  public BuildStatusBuilder() {
    this(false);
  }
  public BuildStatusBuilder(Boolean validationEnabled) {
    this(new BuildStatus(), validationEnabled);
  }
  public BuildStatusBuilder(BuildStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildStatusBuilder(BuildStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildStatus(), validationEnabled);
  }
  public BuildStatusBuilder(BuildStatusFluent<?> fluent,BuildStatus instance) {
    this(fluent, instance, false);
  }
  public BuildStatusBuilder(BuildStatusFluent<?> fluent,BuildStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BuildStatus());

    if (instance != null) {
      fluent.withCancelled(instance.getCancelled());
      fluent.withCompletionTimestamp(instance.getCompletionTimestamp());
      fluent.withConditions(instance.getConditions());
      fluent.withConfig(instance.getConfig());
      fluent.withDuration(instance.getDuration());
      fluent.withLogSnippet(instance.getLogSnippet());
      fluent.withMessage(instance.getMessage());
      fluent.withOutput(instance.getOutput());
      fluent.withOutputDockerImageReference(instance.getOutputDockerImageReference());
      fluent.withPhase(instance.getPhase());
      fluent.withReason(instance.getReason());
      fluent.withStages(instance.getStages());
      fluent.withStartTimestamp(instance.getStartTimestamp());
      fluent.withCancelled(instance.getCancelled());
      fluent.withCompletionTimestamp(instance.getCompletionTimestamp());
      fluent.withConditions(instance.getConditions());
      fluent.withConfig(instance.getConfig());
      fluent.withDuration(instance.getDuration());
      fluent.withLogSnippet(instance.getLogSnippet());
      fluent.withMessage(instance.getMessage());
      fluent.withOutput(instance.getOutput());
      fluent.withOutputDockerImageReference(instance.getOutputDockerImageReference());
      fluent.withPhase(instance.getPhase());
      fluent.withReason(instance.getReason());
      fluent.withStages(instance.getStages());
      fluent.withStartTimestamp(instance.getStartTimestamp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildStatusBuilder(BuildStatus instance) {
    this(instance,false);
  }
  public BuildStatusBuilder(BuildStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BuildStatus());

    if (instance != null) {
      this.withCancelled(instance.getCancelled());
      this.withCompletionTimestamp(instance.getCompletionTimestamp());
      this.withConditions(instance.getConditions());
      this.withConfig(instance.getConfig());
      this.withDuration(instance.getDuration());
      this.withLogSnippet(instance.getLogSnippet());
      this.withMessage(instance.getMessage());
      this.withOutput(instance.getOutput());
      this.withOutputDockerImageReference(instance.getOutputDockerImageReference());
      this.withPhase(instance.getPhase());
      this.withReason(instance.getReason());
      this.withStages(instance.getStages());
      this.withStartTimestamp(instance.getStartTimestamp());
      this.withCancelled(instance.getCancelled());
      this.withCompletionTimestamp(instance.getCompletionTimestamp());
      this.withConditions(instance.getConditions());
      this.withConfig(instance.getConfig());
      this.withDuration(instance.getDuration());
      this.withLogSnippet(instance.getLogSnippet());
      this.withMessage(instance.getMessage());
      this.withOutput(instance.getOutput());
      this.withOutputDockerImageReference(instance.getOutputDockerImageReference());
      this.withPhase(instance.getPhase());
      this.withReason(instance.getReason());
      this.withStages(instance.getStages());
      this.withStartTimestamp(instance.getStartTimestamp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildStatusFluent<?> fluent;
  Boolean validationEnabled;
  public BuildStatus build() {
    BuildStatus buildable = new BuildStatus(fluent.getCancelled(),fluent.getCompletionTimestamp(),fluent.buildConditions(),fluent.buildConfig(),fluent.getDuration(),fluent.getLogSnippet(),fluent.getMessage(),fluent.buildOutput(),fluent.getOutputDockerImageReference(),fluent.getPhase(),fluent.getReason(),fluent.buildStages(),fluent.getStartTimestamp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}