package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaSelectorBuilder extends ClusterResourceQuotaSelectorFluent<ClusterResourceQuotaSelectorBuilder> implements VisitableBuilder<ClusterResourceQuotaSelector,ClusterResourceQuotaSelectorBuilder>{
  public ClusterResourceQuotaSelectorBuilder() {
    this(false);
  }
  public ClusterResourceQuotaSelectorBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaSelector(), validationEnabled);
  }
  public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaSelector(), validationEnabled);
  }
  public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent,ClusterResourceQuotaSelector instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelectorFluent<?> fluent,ClusterResourceQuotaSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterResourceQuotaSelector());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withLabels(instance.getLabels());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withLabels(instance.getLabels());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelector instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaSelectorBuilder(ClusterResourceQuotaSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterResourceQuotaSelector());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withAnnotations(instance.getAnnotations());
      this.withLabels(instance.getLabels());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterResourceQuotaSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterResourceQuotaSelector build() {
    ClusterResourceQuotaSelector buildable = new ClusterResourceQuotaSelector(fluent.getAnnotations(),fluent.buildLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}