package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageChangeTriggerStatusBuilder extends ImageChangeTriggerStatusFluent<ImageChangeTriggerStatusBuilder> implements VisitableBuilder<ImageChangeTriggerStatus,ImageChangeTriggerStatusBuilder>{
  public ImageChangeTriggerStatusBuilder() {
    this(false);
  }
  public ImageChangeTriggerStatusBuilder(Boolean validationEnabled) {
    this(new ImageChangeTriggerStatus(), validationEnabled);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageChangeTriggerStatus(), validationEnabled);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent,ImageChangeTriggerStatus instance) {
    this(fluent, instance, false);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatusFluent<?> fluent,ImageChangeTriggerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageChangeTriggerStatus());

    if (instance != null) {
      fluent.withFrom(instance.getFrom());
      fluent.withLastTriggerTime(instance.getLastTriggerTime());
      fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID());
      fluent.withFrom(instance.getFrom());
      fluent.withLastTriggerTime(instance.getLastTriggerTime());
      fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatus instance) {
    this(instance,false);
  }
  public ImageChangeTriggerStatusBuilder(ImageChangeTriggerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageChangeTriggerStatus());

    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withLastTriggerTime(instance.getLastTriggerTime());
      this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
      this.withFrom(instance.getFrom());
      this.withLastTriggerTime(instance.getLastTriggerTime());
      this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageChangeTriggerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageChangeTriggerStatus build() {
    ImageChangeTriggerStatus buildable = new ImageChangeTriggerStatus(fluent.buildFrom(),fluent.getLastTriggerTime(),fluent.getLastTriggeredImageID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}