package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSourcePathBuilder extends ImageSourcePathFluent<ImageSourcePathBuilder> implements VisitableBuilder<ImageSourcePath,ImageSourcePathBuilder>{
  public ImageSourcePathBuilder() {
    this(false);
  }
  public ImageSourcePathBuilder(Boolean validationEnabled) {
    this(new ImageSourcePath(), validationEnabled);
  }
  public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageSourcePath(), validationEnabled);
  }
  public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent,ImageSourcePath instance) {
    this(fluent, instance, false);
  }
  public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent,ImageSourcePath instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageSourcePath());

    if (instance != null) {
      fluent.withDestinationDir(instance.getDestinationDir());
      fluent.withSourcePath(instance.getSourcePath());
      fluent.withDestinationDir(instance.getDestinationDir());
      fluent.withSourcePath(instance.getSourcePath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageSourcePathBuilder(ImageSourcePath instance) {
    this(instance,false);
  }
  public ImageSourcePathBuilder(ImageSourcePath instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageSourcePath());

    if (instance != null) {
      this.withDestinationDir(instance.getDestinationDir());
      this.withSourcePath(instance.getSourcePath());
      this.withDestinationDir(instance.getDestinationDir());
      this.withSourcePath(instance.getSourcePath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageSourcePathFluent<?> fluent;
  Boolean validationEnabled;
  public ImageSourcePath build() {
    ImageSourcePath buildable = new ImageSourcePath(fluent.getDestinationDir(),fluent.getSourcePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}