package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamTagFluent<A extends ImageStreamTagFluent<A>> extends BaseFluent<A>{
  public ImageStreamTagFluent() {
  }
  public ImageStreamTagFluent(ImageStreamTag instance) {
    instance = (instance != null ? instance : new ImageStreamTag());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withConditions(instance.getConditions());
      this.withGeneration(instance.getGeneration());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withLookupPolicy(instance.getLookupPolicy());
      this.withMetadata(instance.getMetadata());
      this.withTag(instance.getTag());
      this.withApiVersion(instance.getApiVersion());
      this.withConditions(instance.getConditions());
      this.withGeneration(instance.getGeneration());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withLookupPolicy(instance.getLookupPolicy());
      this.withMetadata(instance.getMetadata());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ArrayList<TagEventConditionBuilder> conditions = new ArrayList<TagEventConditionBuilder>();
  private Long generation;
  private ImageBuilder image;
  private String kind;
  private ImageLookupPolicyBuilder lookupPolicy;
  private ObjectMetaBuilder metadata;
  private TagReferenceBuilder tag;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToConditions(int index,TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<TagEventCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<TagEventConditionBuilder>();}
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    if (this.conditions == null) return (A)this;
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<TagEventCondition> items) {
    if (this.conditions == null) return (A)this;
    for (TagEventCondition item : items) {TagEventConditionBuilder builder = new TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<TagEventConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<TagEventConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      TagEventConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<TagEventCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public TagEventCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public TagEventCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public TagEventCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public TagEventCondition buildMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    for (TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    for (TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<TagEventCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (TagEventCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.TagEventCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (TagEventCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,TagEventCondition item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<TagEventConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getGeneration() {
    return this.generation;
  }
  public A withGeneration(Long generation) {
    this.generation=generation; return (A) this;
  }
  public boolean hasGeneration() {
    return this.generation != null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  public ImageNested<A> withNewImageLike(Image item) {
    return new ImageNested(item);
  }
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ImageBuilder().build()));
  }
  public ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public ImageLookupPolicy buildLookupPolicy() {
    return this.lookupPolicy!=null ?this.lookupPolicy.build():null;
  }
  public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
    _visitables.get("lookupPolicy").remove(this.lookupPolicy);
    if (lookupPolicy!=null){ this.lookupPolicy= new ImageLookupPolicyBuilder(lookupPolicy); _visitables.get("lookupPolicy").add(this.lookupPolicy);} else { this.lookupPolicy = null; _visitables.get("lookupPolicy").remove(this.lookupPolicy); } return (A) this;
  }
  public boolean hasLookupPolicy() {
    return this.lookupPolicy != null;
  }
  public A withNewLookupPolicy(Boolean local) {
    return (A)withLookupPolicy(new ImageLookupPolicy(local));
  }
  public LookupPolicyNested<A> withNewLookupPolicy() {
    return new LookupPolicyNested(null);
  }
  public LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
    return new LookupPolicyNested(item);
  }
  public LookupPolicyNested<A> editLookupPolicy() {
    return withNewLookupPolicyLike(java.util.Optional.ofNullable(buildLookupPolicy()).orElse(null));
  }
  public LookupPolicyNested<A> editOrNewLookupPolicy() {
    return withNewLookupPolicyLike(java.util.Optional.ofNullable(buildLookupPolicy()).orElse(new ImageLookupPolicyBuilder().build()));
  }
  public LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
    return withNewLookupPolicyLike(java.util.Optional.ofNullable(buildLookupPolicy()).orElse(item));
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  public TagReference buildTag() {
    return this.tag!=null ?this.tag.build():null;
  }
  public A withTag(TagReference tag) {
    _visitables.get("tag").remove(this.tag);
    if (tag!=null){ this.tag= new TagReferenceBuilder(tag); _visitables.get("tag").add(this.tag);} else { this.tag = null; _visitables.get("tag").remove(this.tag); } return (A) this;
  }
  public boolean hasTag() {
    return this.tag != null;
  }
  public TagNested<A> withNewTag() {
    return new TagNested(null);
  }
  public TagNested<A> withNewTagLike(TagReference item) {
    return new TagNested(item);
  }
  public TagNested<A> editTag() {
    return withNewTagLike(java.util.Optional.ofNullable(buildTag()).orElse(null));
  }
  public TagNested<A> editOrNewTag() {
    return withNewTagLike(java.util.Optional.ofNullable(buildTag()).orElse(new TagReferenceBuilder().build()));
  }
  public TagNested<A> editOrNewTagLike(TagReference item) {
    return withNewTagLike(java.util.Optional.ofNullable(buildTag()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamTagFluent that = (ImageStreamTagFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(generation, that.generation)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(lookupPolicy, that.lookupPolicy)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(tag, that.tag)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  generation,  image,  kind,  lookupPolicy,  metadata,  tag,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generation != null) { sb.append("generation:"); sb.append(generation + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (lookupPolicy != null) { sb.append("lookupPolicy:"); sb.append(lookupPolicy + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends TagEventConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,TagEventCondition item) {
      this.index = index;
      this.builder = new TagEventConditionBuilder(this, item);
    }
    TagEventConditionBuilder builder;
    int index;
    public N and() {
      return (N) ImageStreamTagFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ImageNested<N> extends ImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluent.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  public class LookupPolicyNested<N> extends ImageLookupPolicyFluent<LookupPolicyNested<N>> implements Nested<N>{
    LookupPolicyNested(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluent.this.withLookupPolicy(builder.build());
    }
    public N endLookupPolicy() {
      return and();
    }
    
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluent.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  public class TagNested<N> extends TagReferenceFluent<TagNested<N>> implements Nested<N>{
    TagNested(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagReferenceBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluent.this.withTag(builder.build());
    }
    public N endTag() {
      return and();
    }
    
  }
  
}