package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RepositoryImportStatusBuilder extends RepositoryImportStatusFluent<RepositoryImportStatusBuilder> implements VisitableBuilder<RepositoryImportStatus,RepositoryImportStatusBuilder>{
  public RepositoryImportStatusBuilder() {
    this(false);
  }
  public RepositoryImportStatusBuilder(Boolean validationEnabled) {
    this(new RepositoryImportStatus(), validationEnabled);
  }
  public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RepositoryImportStatus(), validationEnabled);
  }
  public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent,RepositoryImportStatus instance) {
    this(fluent, instance, false);
  }
  public RepositoryImportStatusBuilder(RepositoryImportStatusFluent<?> fluent,RepositoryImportStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RepositoryImportStatus());

    if (instance != null) {
      fluent.withAdditionalTags(instance.getAdditionalTags());
      fluent.withImages(instance.getImages());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalTags(instance.getAdditionalTags());
      fluent.withImages(instance.getImages());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RepositoryImportStatusBuilder(RepositoryImportStatus instance) {
    this(instance,false);
  }
  public RepositoryImportStatusBuilder(RepositoryImportStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RepositoryImportStatus());

    if (instance != null) {
      this.withAdditionalTags(instance.getAdditionalTags());
      this.withImages(instance.getImages());
      this.withStatus(instance.getStatus());
      this.withAdditionalTags(instance.getAdditionalTags());
      this.withImages(instance.getImages());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RepositoryImportStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RepositoryImportStatus build() {
    RepositoryImportStatus buildable = new RepositoryImportStatus(fluent.getAdditionalTags(),fluent.buildImages(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}