package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagImageHookBuilder extends TagImageHookFluent<TagImageHookBuilder> implements VisitableBuilder<TagImageHook,TagImageHookBuilder>{
  public TagImageHookBuilder() {
    this(false);
  }
  public TagImageHookBuilder(Boolean validationEnabled) {
    this(new TagImageHook(), validationEnabled);
  }
  public TagImageHookBuilder(TagImageHookFluent<?> fluent) {
    this(fluent, false);
  }
  public TagImageHookBuilder(TagImageHookFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TagImageHook(), validationEnabled);
  }
  public TagImageHookBuilder(TagImageHookFluent<?> fluent,TagImageHook instance) {
    this(fluent, instance, false);
  }
  public TagImageHookBuilder(TagImageHookFluent<?> fluent,TagImageHook instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TagImageHook());

    if (instance != null) {
      fluent.withContainerName(instance.getContainerName());
      fluent.withTo(instance.getTo());
      fluent.withContainerName(instance.getContainerName());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TagImageHookBuilder(TagImageHook instance) {
    this(instance,false);
  }
  public TagImageHookBuilder(TagImageHook instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TagImageHook());

    if (instance != null) {
      this.withContainerName(instance.getContainerName());
      this.withTo(instance.getTo());
      this.withContainerName(instance.getContainerName());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TagImageHookFluent<?> fluent;
  Boolean validationEnabled;
  public TagImageHook build() {
    TagImageHook buildable = new TagImageHook(fluent.getContainerName(),fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}