package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceConditionBuilder extends TemplateInstanceConditionFluent<TemplateInstanceConditionBuilder> implements VisitableBuilder<TemplateInstanceCondition,TemplateInstanceConditionBuilder>{
  public TemplateInstanceConditionBuilder() {
    this(false);
  }
  public TemplateInstanceConditionBuilder(Boolean validationEnabled) {
    this(new TemplateInstanceCondition(), validationEnabled);
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TemplateInstanceCondition(), validationEnabled);
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceConditionFluent<?> fluent,TemplateInstanceCondition instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceConditionFluent<?> fluent,TemplateInstanceCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TemplateInstanceCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceCondition instance) {
    this(instance,false);
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TemplateInstanceCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TemplateInstanceConditionFluent<?> fluent;
  Boolean validationEnabled;
  public TemplateInstanceCondition build() {
    TemplateInstanceCondition buildable = new TemplateInstanceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}