package io.fabric8.openshift.api.model.runtime;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RawExtensionBuilder extends RawExtensionFluent<RawExtensionBuilder> implements VisitableBuilder<RawExtension,RawExtensionBuilder>{
  public RawExtensionBuilder() {
    this(false);
  }
  public RawExtensionBuilder(Boolean validationEnabled) {
    this(new RawExtension(), validationEnabled);
  }
  public RawExtensionBuilder(RawExtensionFluent<?> fluent) {
    this(fluent, false);
  }
  public RawExtensionBuilder(RawExtensionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RawExtension(), validationEnabled);
  }
  public RawExtensionBuilder(RawExtensionFluent<?> fluent,RawExtension instance) {
    this(fluent, instance, false);
  }
  public RawExtensionBuilder(RawExtensionFluent<?> fluent,RawExtension instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RawExtension());

    if (instance != null) {
      fluent.withValue(instance.getValue());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RawExtensionBuilder(RawExtension instance) {
    this(instance,false);
  }
  public RawExtensionBuilder(RawExtension instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RawExtension());

    if (instance != null) {
      this.withValue(instance.getValue());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  RawExtensionFluent<?> fluent;
  Boolean validationEnabled;
  public RawExtension build() {
    RawExtension buildable = new RawExtension(fluent.getValue());
    return buildable;
  }
  
}