package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SignatureIssuerBuilder extends SignatureIssuerFluent<SignatureIssuerBuilder> implements VisitableBuilder<SignatureIssuer,SignatureIssuerBuilder>{
  public SignatureIssuerBuilder() {
    this(new SignatureIssuer());
  }
  
  public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent) {
    this(fluent, new SignatureIssuer());
  }
  
  public SignatureIssuerBuilder(SignatureIssuerFluent<?> fluent,SignatureIssuer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SignatureIssuerBuilder(SignatureIssuer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SignatureIssuerFluent<?> fluent;
  
  public SignatureIssuer build() {
    SignatureIssuer buildable = new SignatureIssuer(fluent.getCommonName(),fluent.getOrganization());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}