/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.ImageBlobReferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageBlobReferencesFluent<A extends ImageBlobReferencesFluent<A>>
extends BaseFluent<A> {
    private String config;
    private Boolean imageMissing;
    private List<String> layers = new ArrayList<String>();
    private List<String> manifests = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ImageBlobReferencesFluent() {
    }

    public ImageBlobReferencesFluent(ImageBlobReferences instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageBlobReferences instance) {
        ImageBlobReferences imageBlobReferences = instance = instance != null ? instance : new ImageBlobReferences();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withImageMissing(instance.getImageMissing());
            this.withLayers(instance.getLayers());
            this.withManifests(instance.getManifests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getConfig() {
        return this.config;
    }

    public A withConfig(String config) {
        this.config = config;
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public Boolean getImageMissing() {
        return this.imageMissing;
    }

    public A withImageMissing(Boolean imageMissing) {
        this.imageMissing = imageMissing;
        return (A)((Object)this);
    }

    public boolean hasImageMissing() {
        return this.imageMissing != null;
    }

    public A addToLayers(int index, String item) {
        if (this.layers == null) {
            this.layers = new ArrayList<String>();
        }
        this.layers.add(index, item);
        return (A)((Object)this);
    }

    public A setToLayers(int index, String item) {
        if (this.layers == null) {
            this.layers = new ArrayList<String>();
        }
        this.layers.set(index, item);
        return (A)((Object)this);
    }

    public A addToLayers(String ... items) {
        if (this.layers == null) {
            this.layers = new ArrayList<String>();
        }
        for (String item : items) {
            this.layers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLayers(Collection<String> items) {
        if (this.layers == null) {
            this.layers = new ArrayList<String>();
        }
        for (String item : items) {
            this.layers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLayers(String ... items) {
        if (this.layers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.layers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLayers(Collection<String> items) {
        if (this.layers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.layers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLayers() {
        return this.layers;
    }

    public String getLayer(int index) {
        return this.layers.get(index);
    }

    public String getFirstLayer() {
        return this.layers.get(0);
    }

    public String getLastLayer() {
        return this.layers.get(this.layers.size() - 1);
    }

    public String getMatchingLayer(Predicate<String> predicate) {
        for (String item : this.layers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLayer(Predicate<String> predicate) {
        for (String item : this.layers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLayers(List<String> layers) {
        if (layers != null) {
            this.layers = new ArrayList<String>();
            for (String item : layers) {
                this.addToLayers(item);
            }
        } else {
            this.layers = null;
        }
        return (A)((Object)this);
    }

    public A withLayers(String ... layers) {
        if (this.layers != null) {
            this.layers.clear();
            this._visitables.remove((Object)"layers");
        }
        if (layers != null) {
            for (String item : layers) {
                this.addToLayers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLayers() {
        return this.layers != null && !this.layers.isEmpty();
    }

    public A addToManifests(int index, String item) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<String>();
        }
        this.manifests.add(index, item);
        return (A)((Object)this);
    }

    public A setToManifests(int index, String item) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<String>();
        }
        this.manifests.set(index, item);
        return (A)((Object)this);
    }

    public A addToManifests(String ... items) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<String>();
        }
        for (String item : items) {
            this.manifests.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToManifests(Collection<String> items) {
        if (this.manifests == null) {
            this.manifests = new ArrayList<String>();
        }
        for (String item : items) {
            this.manifests.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromManifests(String ... items) {
        if (this.manifests == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.manifests.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromManifests(Collection<String> items) {
        if (this.manifests == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.manifests.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getManifests() {
        return this.manifests;
    }

    public String getManifest(int index) {
        return this.manifests.get(index);
    }

    public String getFirstManifest() {
        return this.manifests.get(0);
    }

    public String getLastManifest() {
        return this.manifests.get(this.manifests.size() - 1);
    }

    public String getMatchingManifest(Predicate<String> predicate) {
        for (String item : this.manifests) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingManifest(Predicate<String> predicate) {
        for (String item : this.manifests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withManifests(List<String> manifests) {
        if (manifests != null) {
            this.manifests = new ArrayList<String>();
            for (String item : manifests) {
                this.addToManifests(item);
            }
        } else {
            this.manifests = null;
        }
        return (A)((Object)this);
    }

    public A withManifests(String ... manifests) {
        if (this.manifests != null) {
            this.manifests.clear();
            this._visitables.remove((Object)"manifests");
        }
        if (manifests != null) {
            for (String item : manifests) {
                this.addToManifests(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasManifests() {
        return this.manifests != null && !this.manifests.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageBlobReferencesFluent that = (ImageBlobReferencesFluent)((Object)o);
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.imageMissing, that.imageMissing)) {
            return false;
        }
        if (!Objects.equals(this.layers, that.layers)) {
            return false;
        }
        if (!Objects.equals(this.manifests, that.manifests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.imageMissing, this.layers, this.manifests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config + ",");
        }
        if (this.imageMissing != null) {
            sb.append("imageMissing:");
            sb.append(this.imageMissing + ",");
        }
        if (this.layers != null && !this.layers.isEmpty()) {
            sb.append("layers:");
            sb.append(this.layers + ",");
        }
        if (this.manifests != null && !this.manifests.isEmpty()) {
            sb.append("manifests:");
            sb.append(this.manifests + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withImageMissing() {
        return this.withImageMissing(true);
    }
}

