package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageBlobReferencesFluent<A extends ImageBlobReferencesFluent<A>> extends BaseFluent<A>{
  public ImageBlobReferencesFluent() {
  }
  
  public ImageBlobReferencesFluent(ImageBlobReferences instance) {
    this.copyInstance(instance);
  }
  private String config;
  private Boolean imageMissing;
  private List<String> layers = new ArrayList<String>();
  private List<String> manifests = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageBlobReferences instance) {
    instance = (instance != null ? instance : new ImageBlobReferences());
    if (instance != null) {
          this.withConfig(instance.getConfig());
          this.withImageMissing(instance.getImageMissing());
          this.withLayers(instance.getLayers());
          this.withManifests(instance.getManifests());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getConfig() {
    return this.config;
  }
  
  public A withConfig(String config) {
    this.config = config;
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public Boolean getImageMissing() {
    return this.imageMissing;
  }
  
  public A withImageMissing(Boolean imageMissing) {
    this.imageMissing = imageMissing;
    return (A) this;
  }
  
  public boolean hasImageMissing() {
    return this.imageMissing != null;
  }
  
  public A addToLayers(int index,String item) {
    if (this.layers == null) {this.layers = new ArrayList<String>();}
    this.layers.add(index, item);
    return (A)this;
  }
  
  public A setToLayers(int index,String item) {
    if (this.layers == null) {this.layers = new ArrayList<String>();}
    this.layers.set(index, item); return (A)this;
  }
  
  public A addToLayers(java.lang.String... items) {
    if (this.layers == null) {this.layers = new ArrayList<String>();}
    for (String item : items) {this.layers.add(item);} return (A)this;
  }
  
  public A addAllToLayers(Collection<String> items) {
    if (this.layers == null) {this.layers = new ArrayList<String>();}
    for (String item : items) {this.layers.add(item);} return (A)this;
  }
  
  public A removeFromLayers(java.lang.String... items) {
    if (this.layers == null) return (A)this;
    for (String item : items) { this.layers.remove(item);} return (A)this;
  }
  
  public A removeAllFromLayers(Collection<String> items) {
    if (this.layers == null) return (A)this;
    for (String item : items) { this.layers.remove(item);} return (A)this;
  }
  
  public List<String> getLayers() {
    return this.layers;
  }
  
  public String getLayer(int index) {
    return this.layers.get(index);
  }
  
  public String getFirstLayer() {
    return this.layers.get(0);
  }
  
  public String getLastLayer() {
    return this.layers.get(layers.size() - 1);
  }
  
  public String getMatchingLayer(Predicate<String> predicate) {
      for (String item : layers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingLayer(Predicate<String> predicate) {
      for (String item : layers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLayers(List<String> layers) {
    if (layers != null) {
        this.layers = new ArrayList();
        for (String item : layers) {
          this.addToLayers(item);
        }
    } else {
      this.layers = null;
    }
    return (A) this;
  }
  
  public A withLayers(java.lang.String... layers) {
    if (this.layers != null) {
        this.layers.clear();
        _visitables.remove("layers");
    }
    if (layers != null) {
      for (String item : layers) {
        this.addToLayers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLayers() {
    return this.layers != null && !this.layers.isEmpty();
  }
  
  public A addToManifests(int index,String item) {
    if (this.manifests == null) {this.manifests = new ArrayList<String>();}
    this.manifests.add(index, item);
    return (A)this;
  }
  
  public A setToManifests(int index,String item) {
    if (this.manifests == null) {this.manifests = new ArrayList<String>();}
    this.manifests.set(index, item); return (A)this;
  }
  
  public A addToManifests(java.lang.String... items) {
    if (this.manifests == null) {this.manifests = new ArrayList<String>();}
    for (String item : items) {this.manifests.add(item);} return (A)this;
  }
  
  public A addAllToManifests(Collection<String> items) {
    if (this.manifests == null) {this.manifests = new ArrayList<String>();}
    for (String item : items) {this.manifests.add(item);} return (A)this;
  }
  
  public A removeFromManifests(java.lang.String... items) {
    if (this.manifests == null) return (A)this;
    for (String item : items) { this.manifests.remove(item);} return (A)this;
  }
  
  public A removeAllFromManifests(Collection<String> items) {
    if (this.manifests == null) return (A)this;
    for (String item : items) { this.manifests.remove(item);} return (A)this;
  }
  
  public List<String> getManifests() {
    return this.manifests;
  }
  
  public String getManifest(int index) {
    return this.manifests.get(index);
  }
  
  public String getFirstManifest() {
    return this.manifests.get(0);
  }
  
  public String getLastManifest() {
    return this.manifests.get(manifests.size() - 1);
  }
  
  public String getMatchingManifest(Predicate<String> predicate) {
      for (String item : manifests) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingManifest(Predicate<String> predicate) {
      for (String item : manifests) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withManifests(List<String> manifests) {
    if (manifests != null) {
        this.manifests = new ArrayList();
        for (String item : manifests) {
          this.addToManifests(item);
        }
    } else {
      this.manifests = null;
    }
    return (A) this;
  }
  
  public A withManifests(java.lang.String... manifests) {
    if (this.manifests != null) {
        this.manifests.clear();
        _visitables.remove("manifests");
    }
    if (manifests != null) {
      for (String item : manifests) {
        this.addToManifests(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasManifests() {
    return this.manifests != null && !this.manifests.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageBlobReferencesFluent that = (ImageBlobReferencesFluent) o;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(imageMissing, that.imageMissing)) return false;
    if (!java.util.Objects.equals(layers, that.layers)) return false;
    if (!java.util.Objects.equals(manifests, that.manifests)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(config,  imageMissing,  layers,  manifests,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (config != null) { sb.append("config:"); sb.append(config + ","); }
    if (imageMissing != null) { sb.append("imageMissing:"); sb.append(imageMissing + ","); }
    if (layers != null && !layers.isEmpty()) { sb.append("layers:"); sb.append(layers + ","); }
    if (manifests != null && !manifests.isEmpty()) { sb.append("manifests:"); sb.append(manifests + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withImageMissing() {
    return withImageMissing(true);
  }
  

}