package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodSecurityPolicySubjectReviewStatusFluent<A extends PodSecurityPolicySubjectReviewStatusFluent<A>> extends BaseFluent<A>{
  public PodSecurityPolicySubjectReviewStatusFluent() {
  }
  
  public PodSecurityPolicySubjectReviewStatusFluent(PodSecurityPolicySubjectReviewStatus instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder allowedBy;
  private String reason;
  private PodTemplateSpecBuilder template;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PodSecurityPolicySubjectReviewStatus instance) {
    instance = (instance != null ? instance : new PodSecurityPolicySubjectReviewStatus());
    if (instance != null) {
          this.withAllowedBy(instance.getAllowedBy());
          this.withReason(instance.getReason());
          this.withTemplate(instance.getTemplate());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ObjectReference buildAllowedBy() {
    return this.allowedBy != null ? this.allowedBy.build() : null;
  }
  
  public A withAllowedBy(ObjectReference allowedBy) {
    this._visitables.remove("allowedBy");
    if (allowedBy != null) {
        this.allowedBy = new ObjectReferenceBuilder(allowedBy);
        this._visitables.get("allowedBy").add(this.allowedBy);
    } else {
        this.allowedBy = null;
        this._visitables.get("allowedBy").remove(this.allowedBy);
    }
    return (A) this;
  }
  
  public boolean hasAllowedBy() {
    return this.allowedBy != null;
  }
  
  public AllowedByNested<A> withNewAllowedBy() {
    return new AllowedByNested(null);
  }
  
  public AllowedByNested<A> withNewAllowedByLike(ObjectReference item) {
    return new AllowedByNested(item);
  }
  
  public AllowedByNested<A> editAllowedBy() {
    return withNewAllowedByLike(java.util.Optional.ofNullable(buildAllowedBy()).orElse(null));
  }
  
  public AllowedByNested<A> editOrNewAllowedBy() {
    return withNewAllowedByLike(java.util.Optional.ofNullable(buildAllowedBy()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public AllowedByNested<A> editOrNewAllowedByLike(ObjectReference item) {
    return withNewAllowedByLike(java.util.Optional.ofNullable(buildAllowedBy()).orElse(item));
  }
  
  public String getReason() {
    return this.reason;
  }
  
  public A withReason(String reason) {
    this.reason = reason;
    return (A) this;
  }
  
  public boolean hasReason() {
    return this.reason != null;
  }
  
  public PodTemplateSpec buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(PodTemplateSpec template) {
    this._visitables.remove("template");
    if (template != null) {
        this.template = new PodTemplateSpecBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodSecurityPolicySubjectReviewStatusFluent that = (PodSecurityPolicySubjectReviewStatusFluent) o;
    if (!java.util.Objects.equals(allowedBy, that.allowedBy)) return false;
    if (!java.util.Objects.equals(reason, that.reason)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allowedBy,  reason,  template,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedBy != null) { sb.append("allowedBy:"); sb.append(allowedBy + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AllowedByNested<N> extends ObjectReferenceFluent<AllowedByNested<N>> implements Nested<N>{
    AllowedByNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) PodSecurityPolicySubjectReviewStatusFluent.this.withAllowedBy(builder.build());
    }
    
    public N endAllowedBy() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) PodSecurityPolicySubjectReviewStatusFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}