package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PolicyRuleBuilder extends PolicyRuleFluent<PolicyRuleBuilder> implements VisitableBuilder<PolicyRule,PolicyRuleBuilder>{
  public PolicyRuleBuilder() {
    this(new PolicyRule());
  }
  
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent) {
    this(fluent, new PolicyRule());
  }
  
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,PolicyRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PolicyRuleBuilder(PolicyRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PolicyRuleFluent<?> fluent;
  
  public PolicyRule build() {
    PolicyRule buildable = new PolicyRule(fluent.getApiGroups(),fluent.getAttributeRestrictions(),fluent.getNonResourceURLs(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}