package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TLSConfigFluent<A extends TLSConfigFluent<A>> extends BaseFluent<A>{
  public TLSConfigFluent() {
  }
  
  public TLSConfigFluent(TLSConfig instance) {
    this.copyInstance(instance);
  }
  private String caCertificate;
  private String certificate;
  private String destinationCACertificate;
  private LocalObjectReferenceBuilder externalCertificate;
  private String insecureEdgeTerminationPolicy;
  private String key;
  private String termination;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TLSConfig instance) {
    instance = (instance != null ? instance : new TLSConfig());
    if (instance != null) {
          this.withCaCertificate(instance.getCaCertificate());
          this.withCertificate(instance.getCertificate());
          this.withDestinationCACertificate(instance.getDestinationCACertificate());
          this.withExternalCertificate(instance.getExternalCertificate());
          this.withInsecureEdgeTerminationPolicy(instance.getInsecureEdgeTerminationPolicy());
          this.withKey(instance.getKey());
          this.withTermination(instance.getTermination());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCaCertificate() {
    return this.caCertificate;
  }
  
  public A withCaCertificate(String caCertificate) {
    this.caCertificate = caCertificate;
    return (A) this;
  }
  
  public boolean hasCaCertificate() {
    return this.caCertificate != null;
  }
  
  public String getCertificate() {
    return this.certificate;
  }
  
  public A withCertificate(String certificate) {
    this.certificate = certificate;
    return (A) this;
  }
  
  public boolean hasCertificate() {
    return this.certificate != null;
  }
  
  public String getDestinationCACertificate() {
    return this.destinationCACertificate;
  }
  
  public A withDestinationCACertificate(String destinationCACertificate) {
    this.destinationCACertificate = destinationCACertificate;
    return (A) this;
  }
  
  public boolean hasDestinationCACertificate() {
    return this.destinationCACertificate != null;
  }
  
  public LocalObjectReference buildExternalCertificate() {
    return this.externalCertificate != null ? this.externalCertificate.build() : null;
  }
  
  public A withExternalCertificate(LocalObjectReference externalCertificate) {
    this._visitables.remove("externalCertificate");
    if (externalCertificate != null) {
        this.externalCertificate = new LocalObjectReferenceBuilder(externalCertificate);
        this._visitables.get("externalCertificate").add(this.externalCertificate);
    } else {
        this.externalCertificate = null;
        this._visitables.get("externalCertificate").remove(this.externalCertificate);
    }
    return (A) this;
  }
  
  public boolean hasExternalCertificate() {
    return this.externalCertificate != null;
  }
  
  public A withNewExternalCertificate(String name) {
    return (A)withExternalCertificate(new LocalObjectReference(name));
  }
  
  public ExternalCertificateNested<A> withNewExternalCertificate() {
    return new ExternalCertificateNested(null);
  }
  
  public ExternalCertificateNested<A> withNewExternalCertificateLike(LocalObjectReference item) {
    return new ExternalCertificateNested(item);
  }
  
  public ExternalCertificateNested<A> editExternalCertificate() {
    return withNewExternalCertificateLike(java.util.Optional.ofNullable(buildExternalCertificate()).orElse(null));
  }
  
  public ExternalCertificateNested<A> editOrNewExternalCertificate() {
    return withNewExternalCertificateLike(java.util.Optional.ofNullable(buildExternalCertificate()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public ExternalCertificateNested<A> editOrNewExternalCertificateLike(LocalObjectReference item) {
    return withNewExternalCertificateLike(java.util.Optional.ofNullable(buildExternalCertificate()).orElse(item));
  }
  
  public String getInsecureEdgeTerminationPolicy() {
    return this.insecureEdgeTerminationPolicy;
  }
  
  public A withInsecureEdgeTerminationPolicy(String insecureEdgeTerminationPolicy) {
    this.insecureEdgeTerminationPolicy = insecureEdgeTerminationPolicy;
    return (A) this;
  }
  
  public boolean hasInsecureEdgeTerminationPolicy() {
    return this.insecureEdgeTerminationPolicy != null;
  }
  
  public String getKey() {
    return this.key;
  }
  
  public A withKey(String key) {
    this.key = key;
    return (A) this;
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public String getTermination() {
    return this.termination;
  }
  
  public A withTermination(String termination) {
    this.termination = termination;
    return (A) this;
  }
  
  public boolean hasTermination() {
    return this.termination != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TLSConfigFluent that = (TLSConfigFluent) o;
    if (!java.util.Objects.equals(caCertificate, that.caCertificate)) return false;
    if (!java.util.Objects.equals(certificate, that.certificate)) return false;
    if (!java.util.Objects.equals(destinationCACertificate, that.destinationCACertificate)) return false;
    if (!java.util.Objects.equals(externalCertificate, that.externalCertificate)) return false;
    if (!java.util.Objects.equals(insecureEdgeTerminationPolicy, that.insecureEdgeTerminationPolicy)) return false;
    if (!java.util.Objects.equals(key, that.key)) return false;
    if (!java.util.Objects.equals(termination, that.termination)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(caCertificate,  certificate,  destinationCACertificate,  externalCertificate,  insecureEdgeTerminationPolicy,  key,  termination,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caCertificate != null) { sb.append("caCertificate:"); sb.append(caCertificate + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (destinationCACertificate != null) { sb.append("destinationCACertificate:"); sb.append(destinationCACertificate + ","); }
    if (externalCertificate != null) { sb.append("externalCertificate:"); sb.append(externalCertificate + ","); }
    if (insecureEdgeTerminationPolicy != null) { sb.append("insecureEdgeTerminationPolicy:"); sb.append(insecureEdgeTerminationPolicy + ","); }
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (termination != null) { sb.append("termination:"); sb.append(termination + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExternalCertificateNested<N> extends LocalObjectReferenceFluent<ExternalCertificateNested<N>> implements Nested<N>{
    ExternalCertificateNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) TLSConfigFluent.this.withExternalCertificate(builder.build());
    }
    
    public N endExternalCertificate() {
      return and();
    }
    
  
  }

}