package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class UserIdentityMappingBuilder extends UserIdentityMappingFluent<UserIdentityMappingBuilder> implements VisitableBuilder<UserIdentityMapping,UserIdentityMappingBuilder>{
  public UserIdentityMappingBuilder() {
    this(new UserIdentityMapping());
  }
  
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent) {
    this(fluent, new UserIdentityMapping());
  }
  
  public UserIdentityMappingBuilder(UserIdentityMappingFluent<?> fluent,UserIdentityMapping instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public UserIdentityMappingBuilder(UserIdentityMapping instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  UserIdentityMappingFluent<?> fluent;
  
  public UserIdentityMapping build() {
    UserIdentityMapping buildable = new UserIdentityMapping(fluent.getApiVersion(),fluent.buildIdentity(),fluent.getKind(),fluent.buildMetadata(),fluent.buildUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}