/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.DeploymentCause;
import io.fabric8.openshift.api.model.DeploymentCauseBuilder;
import io.fabric8.openshift.api.model.DeploymentCauseFluent;
import io.fabric8.openshift.api.model.DeploymentDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentDetailsFluent<A extends DeploymentDetailsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DeploymentCauseBuilder> causes = new ArrayList();
    private String message;
    private Map<String, Object> additionalProperties;

    public DeploymentDetailsFluent() {
    }

    public DeploymentDetailsFluent(DeploymentDetails instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeploymentDetails instance) {
        DeploymentDetails deploymentDetails = instance = instance != null ? instance : new DeploymentDetails();
        if (instance != null) {
            this.withCauses(instance.getCauses());
            this.withMessage(instance.getMessage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCauses(int index, DeploymentCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
        if (index < 0 || index >= this.causes.size()) {
            this._visitables.get((Object)"causes").add(builder);
            this.causes.add(builder);
        } else {
            this._visitables.get((Object)"causes").add(builder);
            this.causes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToCauses(int index, DeploymentCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
        if (index < 0 || index >= this.causes.size()) {
            this._visitables.get((Object)"causes").add(builder);
            this.causes.add(builder);
        } else {
            this._visitables.get((Object)"causes").add(builder);
            this.causes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToCauses(DeploymentCause ... items) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get((Object)"causes").add(builder);
            this.causes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToCauses(Collection<DeploymentCause> items) {
        if (this.causes == null) {
            this.causes = new ArrayList();
        }
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get((Object)"causes").add(builder);
            this.causes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromCauses(DeploymentCause ... items) {
        if (this.causes == null) {
            return (A)((Object)this);
        }
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get((Object)"causes").remove((Object)builder);
            this.causes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCauses(Collection<DeploymentCause> items) {
        if (this.causes == null) {
            return (A)((Object)this);
        }
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get((Object)"causes").remove((Object)builder);
            this.causes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCauses(Predicate<DeploymentCauseBuilder> predicate) {
        if (this.causes == null) {
            return (A)((Object)this);
        }
        Iterator<DeploymentCauseBuilder> each = this.causes.iterator();
        List visitables = this._visitables.get((Object)"causes");
        while (each.hasNext()) {
            DeploymentCauseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DeploymentCause> buildCauses() {
        return this.causes != null ? DeploymentDetailsFluent.build(this.causes) : null;
    }

    public DeploymentCause buildCause(int index) {
        return this.causes.get(index).build();
    }

    public DeploymentCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    public DeploymentCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    public DeploymentCause buildMatchingCause(Predicate<DeploymentCauseBuilder> predicate) {
        for (DeploymentCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCause(Predicate<DeploymentCauseBuilder> predicate) {
        for (DeploymentCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCauses(List<DeploymentCause> causes) {
        if (this.causes != null) {
            this._visitables.get((Object)"causes").clear();
        }
        if (causes != null) {
            this.causes = new ArrayList();
            for (DeploymentCause item : causes) {
                this.addToCauses(item);
            }
        } else {
            this.causes = null;
        }
        return (A)((Object)this);
    }

    public A withCauses(DeploymentCause ... causes) {
        if (this.causes != null) {
            this.causes.clear();
            this._visitables.remove((Object)"causes");
        }
        if (causes != null) {
            for (DeploymentCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    public CausesNested<A> addNewCause() {
        return new CausesNested(-1, null);
    }

    public CausesNested<A> addNewCauseLike(DeploymentCause item) {
        return new CausesNested(-1, item);
    }

    public CausesNested<A> setNewCauseLike(int index, DeploymentCause item) {
        return new CausesNested(index, item);
    }

    public CausesNested<A> editCause(int index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    public CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    public CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    public CausesNested<A> editMatchingCause(Predicate<DeploymentCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.test(this.causes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentDetailsFluent that = (DeploymentDetailsFluent)((Object)o);
        if (!Objects.equals(this.causes, that.causes)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.causes, this.message, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.causes != null && !this.causes.isEmpty()) {
            sb.append("causes:");
            sb.append(String.valueOf(this.causes) + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CausesNested<N>
    extends DeploymentCauseFluent<CausesNested<N>>
    implements Nested<N> {
        DeploymentCauseBuilder builder;
        int index;

        CausesNested(int index, DeploymentCause item) {
            this.index = index;
            this.builder = new DeploymentCauseBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentDetailsFluent.this.setToCauses(this.index, this.builder.build());
        }

        public N endCause() {
            return this.and();
        }
    }
}

