/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.base;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.base.ListMeta;
import io.fabric8.kubernetes.api.model.base.StatusDetails;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "code", "details", "kind", "message", "metadata", "reason", "status"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Status {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1");
    @JsonProperty(value="code")
    private Integer code;
    @JsonProperty(value="details")
    @Valid
    private StatusDetails details;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Status";
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="metadata")
    @Valid
    private ListMeta metadata;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="status")
    private String status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Status() {
    }

    public Status(ApiVersion apiVersion, Integer code, StatusDetails details, String kind, String message, ListMeta metadata, String reason, String status) {
        this.apiVersion = apiVersion;
        this.code = code;
        this.details = details;
        this.kind = kind;
        this.message = message;
        this.metadata = metadata;
        this.reason = reason;
        this.status = status;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="code")
    public Integer getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    public void setCode(Integer code) {
        this.code = code;
    }

    @JsonProperty(value="details")
    public StatusDetails getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    public void setDetails(StatusDetails details) {
        this.details = details;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="metadata")
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(ListMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.apiVersion).append((Object)this.code).append((Object)this.details).append((Object)this.kind).append((Object)this.message).append((Object)this.metadata).append((Object)this.reason).append((Object)this.status).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Status)) {
            return false;
        }
        Status rhs = (Status)other;
        return new EqualsBuilder().append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.code, (Object)rhs.code).append((Object)this.details, (Object)rhs.details).append((Object)this.kind, (Object)rhs.kind).append((Object)this.message, (Object)rhs.message).append((Object)this.metadata, (Object)rhs.metadata).append((Object)this.reason, (Object)rhs.reason).append((Object)this.status, (Object)rhs.status).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

