/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.config.NamedExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"api-version", "certificate-authority", "certificate-authority-data", "extensions", "insecure-skip-tls-verify", "server"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Cluster {
    @JsonProperty(value="api-version")
    private String apiVersion;
    @JsonProperty(value="certificate-authority")
    private String certificateAuthority;
    @JsonProperty(value="certificate-authority-data")
    private String certificateAuthorityData;
    @JsonProperty(value="extensions")
    @Valid
    private List<NamedExtension> extensions = new ArrayList<NamedExtension>();
    @JsonProperty(value="insecure-skip-tls-verify")
    private Boolean insecureSkipTlsVerify;
    @JsonProperty(value="server")
    private String server;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Cluster() {
    }

    public Cluster(String apiVersion, String certificateAuthority, String certificateAuthorityData, List<NamedExtension> extensions, Boolean insecureSkipTlsVerify, String server) {
        this.apiVersion = apiVersion;
        this.certificateAuthority = certificateAuthority;
        this.certificateAuthorityData = certificateAuthorityData;
        this.extensions = extensions;
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        this.server = server;
    }

    @JsonProperty(value="api-version")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="api-version")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="certificate-authority")
    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    @JsonProperty(value="certificate-authority")
    public void setCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
    }

    @JsonProperty(value="certificate-authority-data")
    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    @JsonProperty(value="certificate-authority-data")
    public void setCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
    }

    @JsonProperty(value="extensions")
    public List<NamedExtension> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<NamedExtension> extensions) {
        this.extensions = extensions;
    }

    @JsonProperty(value="insecure-skip-tls-verify")
    public Boolean getInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    @JsonProperty(value="insecure-skip-tls-verify")
    public void setInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
    }

    @JsonProperty(value="server")
    public String getServer() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServer(String server) {
        this.server = server;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.apiVersion).append((Object)this.certificateAuthority).append((Object)this.certificateAuthorityData).append(this.extensions).append((Object)this.insecureSkipTlsVerify).append((Object)this.server).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cluster)) {
            return false;
        }
        Cluster rhs = (Cluster)other;
        return new EqualsBuilder().append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.certificateAuthority, (Object)rhs.certificateAuthority).append((Object)this.certificateAuthorityData, (Object)rhs.certificateAuthorityData).append(this.extensions, rhs.extensions).append((Object)this.insecureSkipTlsVerify, (Object)rhs.insecureSkipTlsVerify).append((Object)this.server, (Object)rhs.server).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }
}

