/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.template;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.openshift.api.model.template.TemplateFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TemplateBuilder
extends TemplateFluent<TemplateBuilder>
implements VisitableBuilder<Template, TemplateBuilder> {
    TemplateFluent<?> fluent;

    public TemplateBuilder() {
        this(new Template());
    }

    public TemplateBuilder(TemplateFluent<?> fluent) {
        this(fluent, new Template());
    }

    public TemplateBuilder(TemplateFluent<?> fluent, Template instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withMetadata(instance.getMetadata());
        fluent.withObjects(instance.getObjects());
        fluent.withParameters(instance.getParameters());
    }

    public TemplateBuilder(Template instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withMetadata(instance.getMetadata());
        this.withObjects(instance.getObjects());
        this.withParameters(instance.getParameters());
    }

    @Override
    public Template build() {
        Template buildable = new Template(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLabels(), this.fluent.getMetadata(), this.fluent.getObjects(), this.fluent.getParameters());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

