/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingBuilder;
import io.fabric8.servicecatalog.client.internal.ServiceBindingOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceBindingResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceBindingHandler
implements ResourceHandler<ServiceBinding, ServiceBindingBuilder> {
    public String getKind() {
        return ServiceBinding.class.getSimpleName();
    }

    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    public ServiceBinding create(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (ServiceBinding)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ServiceBinding[0]);
    }

    public ServiceBinding replace(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (ServiceBinding)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public ServiceBinding reload(OkHttpClient client, Config config, String namespace, ServiceBinding item) {
        return (ServiceBinding)((Gettable)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ServiceBindingBuilder edit(ServiceBinding item) {
        return new ServiceBindingBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceBinding item) {
        return (Boolean)((Deletable)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceBinding item, Watcher<ServiceBinding> watcher) {
        return (Watch)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceBinding item, String resourceVersion, Watcher<ServiceBinding> watcher) {
        return (Watch)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceBinding item, ListOptions listOptions, Watcher<ServiceBinding> watcher) {
        return (Watch)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public ServiceBinding waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceBinding)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ServiceBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceBinding item, Predicate<ServiceBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceBinding)((ServiceBindingResource)new ServiceBindingOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

