/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.servicecatalog.api.model.ServiceClass;
import io.fabric8.servicecatalog.api.model.ServiceClassBuilder;
import io.fabric8.servicecatalog.client.internal.ServiceClassOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceClassHandler
implements ResourceHandler<ServiceClass, ServiceClassBuilder> {
    public String getKind() {
        return ServiceClass.class.getSimpleName();
    }

    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    public ServiceClass create(OkHttpClient client, Config config, String namespace, ServiceClass item) {
        return (ServiceClass)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ServiceClass[0]);
    }

    public ServiceClass replace(OkHttpClient client, Config config, String namespace, ServiceClass item) {
        return (ServiceClass)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ServiceClass reload(OkHttpClient client, Config config, String namespace, ServiceClass item) {
        return (ServiceClass)((Gettable)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ServiceClassBuilder edit(ServiceClass item) {
        return new ServiceClassBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceClass item) {
        return (Boolean)((Deletable)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceClass item, Watcher<ServiceClass> watcher) {
        return (Watch)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceClass item, String resourceVersion, Watcher<ServiceClass> watcher) {
        return (Watch)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceClass item, ListOptions listOptions, Watcher<ServiceClass> watcher) {
        return (Watch)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public ServiceClass waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceClass)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ServiceClass waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceClass item, Predicate<ServiceClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceClass)((Resource)new ServiceClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

