/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client;

import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.servicecatalog.client.DefaultServiceCatalogClient;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;

public class ServiceCatalogExtensionAdapter
implements ExtensionAdapter<ServiceCatalogClient> {
    static final ConcurrentMap<URL, Boolean> IS_SERVICE_CATALOG = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_SERVICE_CATALOG_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Class<ServiceCatalogClient> getExtensionType() {
        return ServiceCatalogClient.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isServiceCatalogAvailable(client);
    }

    public ServiceCatalogClient adapt(Client client) {
        return new DefaultServiceCatalogClient((OkHttpClient)client.adapt(OkHttpClient.class), client.getConfiguration());
    }

    private boolean isServiceCatalogAvailable(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_SERVICE_CATALOG.containsKey(masterUrl)) {
            return (Boolean)IS_SERVICE_CATALOG.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("servicecatalog.k8s.io") && !path.contains("servicecatalog.k8s.io/")) continue;
                USES_SERVICE_CATALOG_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_SERVICE_CATALOG.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_SERVICE_CATALOG.putIfAbsent(masterUrl, false);
        return false;
    }
}

