/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.servicecatalog.api.model.ServicePlan;
import io.fabric8.servicecatalog.api.model.ServicePlanBuilder;
import io.fabric8.servicecatalog.client.internal.ServicePlanOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServicePlanHandler
implements ResourceHandler<ServicePlan, ServicePlanBuilder> {
    public String getKind() {
        return ServicePlan.class.getSimpleName();
    }

    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    public ServicePlan create(OkHttpClient client, Config config, String namespace, ServicePlan item) {
        return (ServicePlan)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ServicePlan[0]);
    }

    public ServicePlan replace(OkHttpClient client, Config config, String namespace, ServicePlan item) {
        return (ServicePlan)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public ServicePlan reload(OkHttpClient client, Config config, String namespace, ServicePlan item) {
        return (ServicePlan)((Gettable)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ServicePlanBuilder edit(ServicePlan item) {
        return new ServicePlanBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServicePlan item) {
        return (Boolean)((EditReplacePatchDeletable)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServicePlan item, Watcher<ServicePlan> watcher) {
        return (Watch)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServicePlan item, String resourceVersion, Watcher<ServicePlan> watcher) {
        return (Watch)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServicePlan item, ListOptions listOptions, Watcher<ServicePlan> watcher) {
        return (Watch)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public ServicePlan waitUntilReady(OkHttpClient client, Config config, String namespace, ServicePlan item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServicePlan)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ServicePlan waitUntilCondition(OkHttpClient client, Config config, String namespace, ServicePlan item, Predicate<ServicePlan> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServicePlan)((Resource)new ServicePlanOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

