/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.servicecatalog.api.model.ClusterServiceClass;
import io.fabric8.servicecatalog.api.model.ClusterServiceClassBuilder;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ClusterServiceClassResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterServiceClassHandler
implements ResourceHandler<ClusterServiceClass, ClusterServiceClassBuilder> {
    public String getKind() {
        return ClusterServiceClass.class.getSimpleName();
    }

    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    public ClusterServiceClass create(OkHttpClient client, Config config, String namespace, ClusterServiceClass item) {
        return (ClusterServiceClass)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).create((Object[])new ClusterServiceClass[0]);
    }

    public ClusterServiceClass replace(OkHttpClient client, Config config, String namespace, ClusterServiceClass item) {
        return (ClusterServiceClass)((ClusterServiceClassResource)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public ClusterServiceClass reload(OkHttpClient client, Config config, String namespace, ClusterServiceClass item) {
        return (ClusterServiceClass)((Gettable)((ClusterServiceClassResource)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ClusterServiceClassBuilder edit(ClusterServiceClass item) {
        return new ClusterServiceClassBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, ClusterServiceClass item) {
        return (Boolean)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete((Object[])new ClusterServiceClass[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterServiceClass item, Watcher<ClusterServiceClass> watcher) {
        return (Watch)((ClusterServiceClassResource)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterServiceClass item, String resourceVersion, Watcher<ClusterServiceClass> watcher) {
        return (Watch)((ClusterServiceClassResource)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public ClusterServiceClass waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterServiceClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterServiceClass)((ClusterServiceClassResource)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ClusterServiceClass waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterServiceClass item, Predicate<ClusterServiceClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterServiceClass)((ClusterServiceClassResource)new ClusterServiceClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

