/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceInstanceHandler
implements ResourceHandler<ServiceInstance, ServiceInstanceBuilder> {
    public String getKind() {
        return ServiceInstance.class.getSimpleName();
    }

    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    public ServiceInstance create(OkHttpClient client, Config config, String namespace, ServiceInstance item) {
        return (ServiceInstance)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new ServiceInstance[0]);
    }

    public ServiceInstance replace(OkHttpClient client, Config config, String namespace, ServiceInstance item) {
        return (ServiceInstance)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public ServiceInstance reload(OkHttpClient client, Config config, String namespace, ServiceInstance item) {
        return (ServiceInstance)((Gettable)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ServiceInstanceBuilder edit(ServiceInstance item) {
        return new ServiceInstanceBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ServiceInstance item) {
        return ((EditReplacePatchDeletable)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceInstance item, Watcher<ServiceInstance> watcher) {
        return ((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceInstance item, String resourceVersion, Watcher<ServiceInstance> watcher) {
        return ((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceInstance item, ListOptions listOptions, Watcher<ServiceInstance> watcher) {
        return ((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public ServiceInstance waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceInstance item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceInstance)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public ServiceInstance waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceInstance item, Predicate<ServiceInstance> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceInstance)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

