/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.client.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.servicecatalog.api.model.ServiceBinding;
import io.fabric8.servicecatalog.api.model.ServiceBindingBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingFluent;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceList;
import io.fabric8.servicecatalog.client.internal.ServiceBindingOperationsImpl;
import io.fabric8.servicecatalog.client.internal.ServiceInstanceResource;
import okhttp3.OkHttpClient;

public class ServiceInstanceOperationsImpl
extends HasMetadataOperation<ServiceInstance, ServiceInstanceList, ServiceInstanceResource>
implements ServiceInstanceResource {
    public ServiceInstanceOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ServiceInstanceOperationsImpl(OperationContext ctx) {
        super(ctx.withApiGroupName("servicecatalog.k8s.io").withApiGroupVersion("v1beta1").withPlural("serviceinstances"));
        this.type = ServiceInstance.class;
        this.listType = ServiceInstanceList.class;
    }

    public BaseOperation<ServiceInstance, ServiceInstanceList, ServiceInstanceResource> newInstance(OperationContext context) {
        return new ServiceInstanceOperationsImpl(context);
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    @Override
    public ServiceBinding bind(String secretName) {
        ServiceInstance item = (ServiceInstance)this.get();
        return (ServiceBinding)new ServiceBindingOperationsImpl(this.context.withItem(null)).create((HasMetadata)((ServiceBindingBuilder)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingBuilder)((ServiceBindingFluent.MetadataNested)new ServiceBindingBuilder().withNewMetadata().withName(item.getMetadata().getName())).endMetadata()).withNewSpec().withSecretName(secretName)).withNewInstanceRef(item.getMetadata().getName())).endSpec()).build());
    }

    public ServiceInstance edit(Visitor ... visitors) {
        return (ServiceInstance)this.patch((HasMetadata)((ServiceInstanceBuilder)new ServiceInstanceBuilder((ServiceInstance)this.getMandatory()).accept(visitors)).build());
    }
}

