/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ServiceClass;
import io.fabric8.servicecatalog.api.model.ServiceClassFluent;
import io.fabric8.servicecatalog.api.model.ServiceClassFluentImpl;

public class ServiceClassBuilder
extends ServiceClassFluentImpl<ServiceClassBuilder>
implements VisitableBuilder<ServiceClass, ServiceClassBuilder> {
    ServiceClassFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceClassBuilder() {
        this(true);
    }

    public ServiceClassBuilder(Boolean validationEnabled) {
        this(new ServiceClass(), validationEnabled);
    }

    public ServiceClassBuilder(ServiceClassFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceClassBuilder(ServiceClassFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceClass(), validationEnabled);
    }

    public ServiceClassBuilder(ServiceClassFluent<?> fluent, ServiceClass instance) {
        this(fluent, instance, true);
    }

    public ServiceClassBuilder(ServiceClassFluent<?> fluent, ServiceClass instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceClassBuilder(ServiceClass instance) {
        this(instance, (Boolean)true);
    }

    public ServiceClassBuilder(ServiceClass instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceClass build() {
        ServiceClass buildable = new ServiceClass(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceClassBuilder that = (ServiceClassBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

