/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ServicePlan;
import io.fabric8.servicecatalog.api.model.ServicePlanFluent;
import io.fabric8.servicecatalog.api.model.ServicePlanFluentImpl;

public class ServicePlanBuilder
extends ServicePlanFluentImpl<ServicePlanBuilder>
implements VisitableBuilder<ServicePlan, ServicePlanBuilder> {
    ServicePlanFluent<?> fluent;
    Boolean validationEnabled;

    public ServicePlanBuilder() {
        this(true);
    }

    public ServicePlanBuilder(Boolean validationEnabled) {
        this(new ServicePlan(), validationEnabled);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServicePlan(), validationEnabled);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent, ServicePlan instance) {
        this(fluent, instance, true);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent, ServicePlan instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServicePlanBuilder(ServicePlan instance) {
        this(instance, (Boolean)true);
    }

    public ServicePlanBuilder(ServicePlan instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServicePlan build() {
        ServicePlan buildable = new ServicePlan(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicePlanBuilder that = (ServicePlanBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

