/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstanceSpec;
import io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluent;
import io.fabric8.servicecatalog.api.model.ServiceInstanceSpecFluentImpl;

public class ServiceInstanceSpecBuilder
extends ServiceInstanceSpecFluentImpl<ServiceInstanceSpecBuilder>
implements VisitableBuilder<ServiceInstanceSpec, ServiceInstanceSpecBuilder> {
    ServiceInstanceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceInstanceSpecBuilder() {
        this(true);
    }

    public ServiceInstanceSpecBuilder(Boolean validationEnabled) {
        this(new ServiceInstanceSpec(), validationEnabled);
    }

    public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceInstanceSpec(), validationEnabled);
    }

    public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent, ServiceInstanceSpec instance) {
        this(fluent, instance, true);
    }

    public ServiceInstanceSpecBuilder(ServiceInstanceSpecFluent<?> fluent, ServiceInstanceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
        fluent.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
        fluent.withClusterServiceClassName(instance.getClusterServiceClassName());
        fluent.withClusterServiceClassRef(instance.getClusterServiceClassRef());
        fluent.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
        fluent.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
        fluent.withClusterServicePlanName(instance.getClusterServicePlanName());
        fluent.withClusterServicePlanRef(instance.getClusterServicePlanRef());
        fluent.withExternalID(instance.getExternalID());
        fluent.withParameters(instance.getParameters());
        fluent.withParametersFrom(instance.getParametersFrom());
        fluent.withUpdateRequests(instance.getUpdateRequests());
        fluent.withUserInfo(instance.getUserInfo());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstanceSpecBuilder(ServiceInstanceSpec instance) {
        this(instance, (Boolean)true);
    }

    public ServiceInstanceSpecBuilder(ServiceInstanceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterServiceClassExternalID(instance.getClusterServiceClassExternalID());
        this.withClusterServiceClassExternalName(instance.getClusterServiceClassExternalName());
        this.withClusterServiceClassName(instance.getClusterServiceClassName());
        this.withClusterServiceClassRef(instance.getClusterServiceClassRef());
        this.withClusterServicePlanExternalID(instance.getClusterServicePlanExternalID());
        this.withClusterServicePlanExternalName(instance.getClusterServicePlanExternalName());
        this.withClusterServicePlanName(instance.getClusterServicePlanName());
        this.withClusterServicePlanRef(instance.getClusterServicePlanRef());
        this.withExternalID(instance.getExternalID());
        this.withParameters(instance.getParameters());
        this.withParametersFrom(instance.getParametersFrom());
        this.withUpdateRequests(instance.getUpdateRequests());
        this.withUserInfo(instance.getUserInfo());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstanceSpec build() {
        ServiceInstanceSpec buildable = new ServiceInstanceSpec(this.fluent.getClusterServiceClassExternalID(), this.fluent.getClusterServiceClassExternalName(), this.fluent.getClusterServiceClassName(), this.fluent.getClusterServiceClassRef(), this.fluent.getClusterServicePlanExternalID(), this.fluent.getClusterServicePlanExternalName(), this.fluent.getClusterServicePlanName(), this.fluent.getClusterServicePlanRef(), this.fluent.getExternalID(), this.fluent.getParameters(), this.fluent.getParametersFrom(), this.fluent.getUpdateRequests(), this.fluent.getUserInfo());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceSpecBuilder that = (ServiceInstanceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

