/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.servicecatalog.api.model.ServiceBindingCondition;
import io.fabric8.servicecatalog.api.model.ServiceBindingConditionBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingConditionFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceBindingPropertiesState;
import io.fabric8.servicecatalog.api.model.ServiceBindingPropertiesStateBuilder;
import io.fabric8.servicecatalog.api.model.ServiceBindingPropertiesStateFluentImpl;
import io.fabric8.servicecatalog.api.model.ServiceBindingStatus;
import io.fabric8.servicecatalog.api.model.ServiceBindingStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServiceBindingStatusFluentImpl<A extends ServiceBindingStatusFluent<A>>
extends BaseFluent<A>
implements ServiceBindingStatusFluent<A> {
    private Boolean asyncOpInProgress;
    private List<ServiceBindingConditionBuilder> conditions;
    private String currentOperation;
    private ServiceBindingPropertiesStateBuilder externalProperties;
    private ServiceBindingPropertiesStateBuilder inProgressProperties;
    private String lastOperation;
    private String operationStartTime;
    private Boolean orphanMitigationInProgress;
    private Long reconciledGeneration;
    private String unbindStatus;

    public ServiceBindingStatusFluentImpl() {
    }

    public ServiceBindingStatusFluentImpl(ServiceBindingStatus instance) {
        this.withAsyncOpInProgress(instance.getAsyncOpInProgress());
        this.withConditions(instance.getConditions());
        this.withCurrentOperation(instance.getCurrentOperation());
        this.withExternalProperties(instance.getExternalProperties());
        this.withInProgressProperties(instance.getInProgressProperties());
        this.withLastOperation(instance.getLastOperation());
        this.withOperationStartTime(instance.getOperationStartTime());
        this.withOrphanMitigationInProgress(instance.getOrphanMitigationInProgress());
        this.withReconciledGeneration(instance.getReconciledGeneration());
        this.withUnbindStatus(instance.getUnbindStatus());
    }

    @Override
    public Boolean isAsyncOpInProgress() {
        return this.asyncOpInProgress;
    }

    @Override
    public A withAsyncOpInProgress(Boolean asyncOpInProgress) {
        this.asyncOpInProgress = asyncOpInProgress;
        return (A)this;
    }

    @Override
    public Boolean hasAsyncOpInProgress() {
        return this.asyncOpInProgress != null;
    }

    @Override
    public A withNewAsyncOpInProgress(String arg1) {
        return this.withAsyncOpInProgress(new Boolean(arg1));
    }

    @Override
    public A withNewAsyncOpInProgress(boolean arg1) {
        return this.withAsyncOpInProgress(new Boolean(arg1));
    }

    @Override
    public A addToConditions(int index, ServiceBindingCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ServiceBindingConditionBuilder>();
        }
        ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, ServiceBindingCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ServiceBindingConditionBuilder>();
        }
        ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ServiceBindingCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ServiceBindingConditionBuilder>();
        }
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ServiceBindingCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ServiceBindingConditionBuilder>();
        }
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ServiceBindingCondition ... items) {
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ServiceBindingCondition> items) {
        for (ServiceBindingCondition item : items) {
            ServiceBindingConditionBuilder builder = new ServiceBindingConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ServiceBindingConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ServiceBindingConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ServiceBindingConditionBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceBindingCondition> getConditions() {
        return ServiceBindingStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<ServiceBindingCondition> buildConditions() {
        return ServiceBindingStatusFluentImpl.build(this.conditions);
    }

    @Override
    public ServiceBindingCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ServiceBindingCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ServiceBindingCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ServiceBindingCondition buildMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
        for (ServiceBindingConditionBuilder item : this.conditions) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
        for (ServiceBindingConditionBuilder item : this.conditions) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<ServiceBindingCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ServiceBindingConditionBuilder>();
            for (ServiceBindingCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(ServiceBindingCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (ServiceBindingCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ServiceBindingCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> addNewConditionLike(ServiceBindingCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> setNewConditionLike(int index, ServiceBindingCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ServiceBindingStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ServiceBindingConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply((Object)this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getCurrentOperation() {
        return this.currentOperation;
    }

    @Override
    public A withCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentOperation() {
        return this.currentOperation != null;
    }

    @Override
    public A withNewCurrentOperation(String arg1) {
        return this.withCurrentOperation(new String(arg1));
    }

    @Override
    public A withNewCurrentOperation(StringBuilder arg1) {
        return this.withCurrentOperation(new String(arg1));
    }

    @Override
    public A withNewCurrentOperation(StringBuffer arg1) {
        return this.withCurrentOperation(new String(arg1));
    }

    @Override
    @Deprecated
    public ServiceBindingPropertiesState getExternalProperties() {
        return this.externalProperties != null ? this.externalProperties.build() : null;
    }

    @Override
    public ServiceBindingPropertiesState buildExternalProperties() {
        return this.externalProperties != null ? this.externalProperties.build() : null;
    }

    @Override
    public A withExternalProperties(ServiceBindingPropertiesState externalProperties) {
        this._visitables.get((Object)"externalProperties").remove(this.externalProperties);
        if (externalProperties != null) {
            this.externalProperties = new ServiceBindingPropertiesStateBuilder(externalProperties);
            this._visitables.get((Object)"externalProperties").add(this.externalProperties);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalProperties() {
        return this.externalProperties != null;
    }

    @Override
    public ServiceBindingStatusFluent.ExternalPropertiesNested<A> withNewExternalProperties() {
        return new ExternalPropertiesNestedImpl();
    }

    @Override
    public ServiceBindingStatusFluent.ExternalPropertiesNested<A> withNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
        return new ExternalPropertiesNestedImpl(item);
    }

    @Override
    public ServiceBindingStatusFluent.ExternalPropertiesNested<A> editExternalProperties() {
        return this.withNewExternalPropertiesLike(this.getExternalProperties());
    }

    @Override
    public ServiceBindingStatusFluent.ExternalPropertiesNested<A> editOrNewExternalProperties() {
        return this.withNewExternalPropertiesLike(this.getExternalProperties() != null ? this.getExternalProperties() : new ServiceBindingPropertiesStateBuilder().build());
    }

    @Override
    public ServiceBindingStatusFluent.ExternalPropertiesNested<A> editOrNewExternalPropertiesLike(ServiceBindingPropertiesState item) {
        return this.withNewExternalPropertiesLike(this.getExternalProperties() != null ? this.getExternalProperties() : item);
    }

    @Override
    @Deprecated
    public ServiceBindingPropertiesState getInProgressProperties() {
        return this.inProgressProperties != null ? this.inProgressProperties.build() : null;
    }

    @Override
    public ServiceBindingPropertiesState buildInProgressProperties() {
        return this.inProgressProperties != null ? this.inProgressProperties.build() : null;
    }

    @Override
    public A withInProgressProperties(ServiceBindingPropertiesState inProgressProperties) {
        this._visitables.get((Object)"inProgressProperties").remove(this.inProgressProperties);
        if (inProgressProperties != null) {
            this.inProgressProperties = new ServiceBindingPropertiesStateBuilder(inProgressProperties);
            this._visitables.get((Object)"inProgressProperties").add(this.inProgressProperties);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInProgressProperties() {
        return this.inProgressProperties != null;
    }

    @Override
    public ServiceBindingStatusFluent.InProgressPropertiesNested<A> withNewInProgressProperties() {
        return new InProgressPropertiesNestedImpl();
    }

    @Override
    public ServiceBindingStatusFluent.InProgressPropertiesNested<A> withNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
        return new InProgressPropertiesNestedImpl(item);
    }

    @Override
    public ServiceBindingStatusFluent.InProgressPropertiesNested<A> editInProgressProperties() {
        return this.withNewInProgressPropertiesLike(this.getInProgressProperties());
    }

    @Override
    public ServiceBindingStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressProperties() {
        return this.withNewInProgressPropertiesLike(this.getInProgressProperties() != null ? this.getInProgressProperties() : new ServiceBindingPropertiesStateBuilder().build());
    }

    @Override
    public ServiceBindingStatusFluent.InProgressPropertiesNested<A> editOrNewInProgressPropertiesLike(ServiceBindingPropertiesState item) {
        return this.withNewInProgressPropertiesLike(this.getInProgressProperties() != null ? this.getInProgressProperties() : item);
    }

    @Override
    public String getLastOperation() {
        return this.lastOperation;
    }

    @Override
    public A withLastOperation(String lastOperation) {
        this.lastOperation = lastOperation;
        return (A)this;
    }

    @Override
    public Boolean hasLastOperation() {
        return this.lastOperation != null;
    }

    @Override
    public A withNewLastOperation(String arg1) {
        return this.withLastOperation(new String(arg1));
    }

    @Override
    public A withNewLastOperation(StringBuilder arg1) {
        return this.withLastOperation(new String(arg1));
    }

    @Override
    public A withNewLastOperation(StringBuffer arg1) {
        return this.withLastOperation(new String(arg1));
    }

    @Override
    public String getOperationStartTime() {
        return this.operationStartTime;
    }

    @Override
    public A withOperationStartTime(String operationStartTime) {
        this.operationStartTime = operationStartTime;
        return (A)this;
    }

    @Override
    public Boolean hasOperationStartTime() {
        return this.operationStartTime != null;
    }

    @Override
    public A withNewOperationStartTime(String arg1) {
        return this.withOperationStartTime(new String(arg1));
    }

    @Override
    public A withNewOperationStartTime(StringBuilder arg1) {
        return this.withOperationStartTime(new String(arg1));
    }

    @Override
    public A withNewOperationStartTime(StringBuffer arg1) {
        return this.withOperationStartTime(new String(arg1));
    }

    @Override
    public Boolean isOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress;
    }

    @Override
    public A withOrphanMitigationInProgress(Boolean orphanMitigationInProgress) {
        this.orphanMitigationInProgress = orphanMitigationInProgress;
        return (A)this;
    }

    @Override
    public Boolean hasOrphanMitigationInProgress() {
        return this.orphanMitigationInProgress != null;
    }

    @Override
    public A withNewOrphanMitigationInProgress(String arg1) {
        return this.withOrphanMitigationInProgress(new Boolean(arg1));
    }

    @Override
    public A withNewOrphanMitigationInProgress(boolean arg1) {
        return this.withOrphanMitigationInProgress(new Boolean(arg1));
    }

    @Override
    public Long getReconciledGeneration() {
        return this.reconciledGeneration;
    }

    @Override
    public A withReconciledGeneration(Long reconciledGeneration) {
        this.reconciledGeneration = reconciledGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasReconciledGeneration() {
        return this.reconciledGeneration != null;
    }

    @Override
    public String getUnbindStatus() {
        return this.unbindStatus;
    }

    @Override
    public A withUnbindStatus(String unbindStatus) {
        this.unbindStatus = unbindStatus;
        return (A)this;
    }

    @Override
    public Boolean hasUnbindStatus() {
        return this.unbindStatus != null;
    }

    @Override
    public A withNewUnbindStatus(String arg1) {
        return this.withUnbindStatus(new String(arg1));
    }

    @Override
    public A withNewUnbindStatus(StringBuilder arg1) {
        return this.withUnbindStatus(new String(arg1));
    }

    @Override
    public A withNewUnbindStatus(StringBuffer arg1) {
        return this.withUnbindStatus(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceBindingStatusFluentImpl that = (ServiceBindingStatusFluentImpl)o;
        if (this.asyncOpInProgress != null ? !this.asyncOpInProgress.equals(that.asyncOpInProgress) : that.asyncOpInProgress != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentOperation != null ? !this.currentOperation.equals(that.currentOperation) : that.currentOperation != null) {
            return false;
        }
        if (this.externalProperties != null ? !this.externalProperties.equals(that.externalProperties) : that.externalProperties != null) {
            return false;
        }
        if (this.inProgressProperties != null ? !this.inProgressProperties.equals(that.inProgressProperties) : that.inProgressProperties != null) {
            return false;
        }
        if (this.lastOperation != null ? !this.lastOperation.equals(that.lastOperation) : that.lastOperation != null) {
            return false;
        }
        if (this.operationStartTime != null ? !this.operationStartTime.equals(that.operationStartTime) : that.operationStartTime != null) {
            return false;
        }
        if (this.orphanMitigationInProgress != null ? !this.orphanMitigationInProgress.equals(that.orphanMitigationInProgress) : that.orphanMitigationInProgress != null) {
            return false;
        }
        if (this.reconciledGeneration != null ? !this.reconciledGeneration.equals(that.reconciledGeneration) : that.reconciledGeneration != null) {
            return false;
        }
        return !(this.unbindStatus != null ? !this.unbindStatus.equals(that.unbindStatus) : that.unbindStatus != null);
    }

    public class InProgressPropertiesNestedImpl<N>
    extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingStatusFluent.InProgressPropertiesNested<N>>
    implements ServiceBindingStatusFluent.InProgressPropertiesNested<N>,
    Nested<N> {
        private final ServiceBindingPropertiesStateBuilder builder;

        InProgressPropertiesNestedImpl(ServiceBindingPropertiesState item) {
            this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
        }

        InProgressPropertiesNestedImpl() {
            this.builder = new ServiceBindingPropertiesStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingStatusFluentImpl.this.withInProgressProperties(this.builder.build());
        }

        @Override
        public N endInProgressProperties() {
            return this.and();
        }
    }

    public class ExternalPropertiesNestedImpl<N>
    extends ServiceBindingPropertiesStateFluentImpl<ServiceBindingStatusFluent.ExternalPropertiesNested<N>>
    implements ServiceBindingStatusFluent.ExternalPropertiesNested<N>,
    Nested<N> {
        private final ServiceBindingPropertiesStateBuilder builder;

        ExternalPropertiesNestedImpl(ServiceBindingPropertiesState item) {
            this.builder = new ServiceBindingPropertiesStateBuilder(this, item);
        }

        ExternalPropertiesNestedImpl() {
            this.builder = new ServiceBindingPropertiesStateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingStatusFluentImpl.this.withExternalProperties(this.builder.build());
        }

        @Override
        public N endExternalProperties() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ServiceBindingConditionFluentImpl<ServiceBindingStatusFluent.ConditionsNested<N>>
    implements ServiceBindingStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ServiceBindingConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, ServiceBindingCondition item) {
            this.index = index;
            this.builder = new ServiceBindingConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceBindingConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceBindingStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

