/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerSpec;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerSpecFluent;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerSpecFluentImpl;
import io.fabric8.servicecatalog.api.model.EditableClusterServiceBrokerSpec;
import java.util.Objects;

public class ClusterServiceBrokerSpecBuilder
extends ClusterServiceBrokerSpecFluentImpl<ClusterServiceBrokerSpecBuilder>
implements VisitableBuilder<ClusterServiceBrokerSpec, ClusterServiceBrokerSpecBuilder> {
    ClusterServiceBrokerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterServiceBrokerSpecBuilder() {
        this(true);
    }

    public ClusterServiceBrokerSpecBuilder(Boolean validationEnabled) {
        this(new ClusterServiceBrokerSpec(), validationEnabled);
    }

    public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterServiceBrokerSpec(), validationEnabled);
    }

    public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent, ClusterServiceBrokerSpec instance) {
        this(fluent, instance, true);
    }

    public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpecFluent<?> fluent, ClusterServiceBrokerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuthInfo(instance.getAuthInfo());
        fluent.withCaBundle(instance.getCaBundle());
        fluent.withCatalogRestrictions(instance.getCatalogRestrictions());
        fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        fluent.withRelistBehavior(instance.getRelistBehavior());
        fluent.withRelistDuration(instance.getRelistDuration());
        fluent.withRelistRequests(instance.getRelistRequests());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpec instance) {
        this(instance, (Boolean)true);
    }

    public ClusterServiceBrokerSpecBuilder(ClusterServiceBrokerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuthInfo(instance.getAuthInfo());
        this.withCaBundle(instance.getCaBundle());
        this.withCatalogRestrictions(instance.getCatalogRestrictions());
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        this.withRelistBehavior(instance.getRelistBehavior());
        this.withRelistDuration(instance.getRelistDuration());
        this.withRelistRequests(instance.getRelistRequests());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public EditableClusterServiceBrokerSpec build() {
        EditableClusterServiceBrokerSpec buildable = new EditableClusterServiceBrokerSpec(this.fluent.getAuthInfo(), this.fluent.getCaBundle(), this.fluent.getCatalogRestrictions(), this.fluent.isInsecureSkipTLSVerify(), this.fluent.getRelistBehavior(), this.fluent.getRelistDuration(), this.fluent.getRelistRequests(), this.fluent.getUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterServiceBrokerSpecBuilder that = (ClusterServiceBrokerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

