/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.EditableServiceInstanceList;
import io.fabric8.servicecatalog.api.model.ServiceInstanceList;
import io.fabric8.servicecatalog.api.model.ServiceInstanceListFluent;
import io.fabric8.servicecatalog.api.model.ServiceInstanceListFluentImpl;
import java.util.Objects;

public class ServiceInstanceListBuilder
extends ServiceInstanceListFluentImpl<ServiceInstanceListBuilder>
implements VisitableBuilder<ServiceInstanceList, ServiceInstanceListBuilder> {
    ServiceInstanceListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceInstanceListBuilder() {
        this(true);
    }

    public ServiceInstanceListBuilder(Boolean validationEnabled) {
        this(new ServiceInstanceList(), validationEnabled);
    }

    public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceInstanceList(), validationEnabled);
    }

    public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent, ServiceInstanceList instance) {
        this(fluent, instance, true);
    }

    public ServiceInstanceListBuilder(ServiceInstanceListFluent<?> fluent, ServiceInstanceList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstanceListBuilder(ServiceInstanceList instance) {
        this(instance, (Boolean)true);
    }

    public ServiceInstanceListBuilder(ServiceInstanceList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public EditableServiceInstanceList build() {
        EditableServiceInstanceList buildable = new EditableServiceInstanceList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceInstanceListBuilder that = (ServiceInstanceListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

