package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterServiceClassBuilder extends ClusterServiceClassFluent<ClusterServiceClassBuilder> implements VisitableBuilder<ClusterServiceClass,ClusterServiceClassBuilder>{
  public ClusterServiceClassBuilder() {
    this(new ClusterServiceClass());
  }
  
  public ClusterServiceClassBuilder(ClusterServiceClassFluent<?> fluent) {
    this(fluent, new ClusterServiceClass());
  }
  
  public ClusterServiceClassBuilder(ClusterServiceClassFluent<?> fluent,ClusterServiceClass instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterServiceClassBuilder(ClusterServiceClass instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterServiceClassFluent<?> fluent;
  
  public ClusterServiceClass build() {
    ClusterServiceClass buildable = new ClusterServiceClass(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}