package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServicePlanStatusBuilder extends ServicePlanStatusFluent<ServicePlanStatusBuilder> implements VisitableBuilder<ServicePlanStatus,ServicePlanStatusBuilder>{
  public ServicePlanStatusBuilder() {
    this(new ServicePlanStatus());
  }
  
  public ServicePlanStatusBuilder(ServicePlanStatusFluent<?> fluent) {
    this(fluent, new ServicePlanStatus());
  }
  
  public ServicePlanStatusBuilder(ServicePlanStatusFluent<?> fluent,ServicePlanStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServicePlanStatusBuilder(ServicePlanStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServicePlanStatusFluent<?> fluent;
  
  public ServicePlanStatus build() {
    ServicePlanStatus buildable = new ServicePlanStatus(fluent.getRemovedFromBrokerCatalog());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}