package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterBasicAuthConfigBuilder extends ClusterBasicAuthConfigFluent<ClusterBasicAuthConfigBuilder> implements VisitableBuilder<ClusterBasicAuthConfig,ClusterBasicAuthConfigBuilder>{
  public ClusterBasicAuthConfigBuilder() {
    this(new ClusterBasicAuthConfig());
  }
  
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfigFluent<?> fluent) {
    this(fluent, new ClusterBasicAuthConfig());
  }
  
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfigFluent<?> fluent,ClusterBasicAuthConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterBasicAuthConfigBuilder(ClusterBasicAuthConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterBasicAuthConfigFluent<?> fluent;
  
  public ClusterBasicAuthConfig build() {
    ClusterBasicAuthConfig buildable = new ClusterBasicAuthConfig(fluent.buildSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}