package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceClassStatusBuilder extends ServiceClassStatusFluent<ServiceClassStatusBuilder> implements VisitableBuilder<ServiceClassStatus,ServiceClassStatusBuilder>{
  public ServiceClassStatusBuilder() {
    this(new ServiceClassStatus());
  }
  
  public ServiceClassStatusBuilder(ServiceClassStatusFluent<?> fluent) {
    this(fluent, new ServiceClassStatus());
  }
  
  public ServiceClassStatusBuilder(ServiceClassStatusFluent<?> fluent,ServiceClassStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceClassStatusBuilder(ServiceClassStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceClassStatusFluent<?> fluent;
  
  public ServiceClassStatus build() {
    ServiceClassStatus buildable = new ServiceClassStatus(fluent.getRemovedFromBrokerCatalog());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}