/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.servicecatalog.api.model.CatalogRestrictions;
import io.fabric8.servicecatalog.api.model.CatalogRestrictionsBuilder;
import io.fabric8.servicecatalog.api.model.CatalogRestrictionsFluent;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerAuthInfo;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerAuthInfoBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerAuthInfoFluent;
import io.fabric8.servicecatalog.api.model.ClusterServiceBrokerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterServiceBrokerSpecFluent<A extends ClusterServiceBrokerSpecFluent<A>>
extends BaseFluent<A> {
    private ClusterServiceBrokerAuthInfoBuilder authInfo;
    private String caBundle;
    private CatalogRestrictionsBuilder catalogRestrictions;
    private Boolean insecureSkipTLSVerify;
    private String relistBehavior;
    private Duration relistDuration;
    private Long relistRequests;
    private String url;
    private Map<String, Object> additionalProperties;

    public ClusterServiceBrokerSpecFluent() {
    }

    public ClusterServiceBrokerSpecFluent(ClusterServiceBrokerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterServiceBrokerSpec instance) {
        ClusterServiceBrokerSpec clusterServiceBrokerSpec = instance = instance != null ? instance : new ClusterServiceBrokerSpec();
        if (instance != null) {
            this.withAuthInfo(instance.getAuthInfo());
            this.withCaBundle(instance.getCaBundle());
            this.withCatalogRestrictions(instance.getCatalogRestrictions());
            this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
            this.withRelistBehavior(instance.getRelistBehavior());
            this.withRelistDuration(instance.getRelistDuration());
            this.withRelistRequests(instance.getRelistRequests());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterServiceBrokerAuthInfo buildAuthInfo() {
        return this.authInfo != null ? this.authInfo.build() : null;
    }

    public A withAuthInfo(ClusterServiceBrokerAuthInfo authInfo) {
        this._visitables.remove((Object)"authInfo");
        if (authInfo != null) {
            this.authInfo = new ClusterServiceBrokerAuthInfoBuilder(authInfo);
            this._visitables.get((Object)"authInfo").add(this.authInfo);
        } else {
            this.authInfo = null;
            this._visitables.get((Object)"authInfo").remove((Object)this.authInfo);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public AuthInfoNested<A> withNewAuthInfo() {
        return new AuthInfoNested(null);
    }

    public AuthInfoNested<A> withNewAuthInfoLike(ClusterServiceBrokerAuthInfo item) {
        return new AuthInfoNested(item);
    }

    public AuthInfoNested<A> editAuthInfo() {
        return this.withNewAuthInfoLike(Optional.ofNullable(this.buildAuthInfo()).orElse(null));
    }

    public AuthInfoNested<A> editOrNewAuthInfo() {
        return this.withNewAuthInfoLike(Optional.ofNullable(this.buildAuthInfo()).orElse(new ClusterServiceBrokerAuthInfoBuilder().build()));
    }

    public AuthInfoNested<A> editOrNewAuthInfoLike(ClusterServiceBrokerAuthInfo item) {
        return this.withNewAuthInfoLike(Optional.ofNullable(this.buildAuthInfo()).orElse(item));
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)((Object)this);
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public CatalogRestrictions buildCatalogRestrictions() {
        return this.catalogRestrictions != null ? this.catalogRestrictions.build() : null;
    }

    public A withCatalogRestrictions(CatalogRestrictions catalogRestrictions) {
        this._visitables.remove((Object)"catalogRestrictions");
        if (catalogRestrictions != null) {
            this.catalogRestrictions = new CatalogRestrictionsBuilder(catalogRestrictions);
            this._visitables.get((Object)"catalogRestrictions").add(this.catalogRestrictions);
        } else {
            this.catalogRestrictions = null;
            this._visitables.get((Object)"catalogRestrictions").remove((Object)this.catalogRestrictions);
        }
        return (A)((Object)this);
    }

    public boolean hasCatalogRestrictions() {
        return this.catalogRestrictions != null;
    }

    public CatalogRestrictionsNested<A> withNewCatalogRestrictions() {
        return new CatalogRestrictionsNested(null);
    }

    public CatalogRestrictionsNested<A> withNewCatalogRestrictionsLike(CatalogRestrictions item) {
        return new CatalogRestrictionsNested(item);
    }

    public CatalogRestrictionsNested<A> editCatalogRestrictions() {
        return this.withNewCatalogRestrictionsLike(Optional.ofNullable(this.buildCatalogRestrictions()).orElse(null));
    }

    public CatalogRestrictionsNested<A> editOrNewCatalogRestrictions() {
        return this.withNewCatalogRestrictionsLike(Optional.ofNullable(this.buildCatalogRestrictions()).orElse(new CatalogRestrictionsBuilder().build()));
    }

    public CatalogRestrictionsNested<A> editOrNewCatalogRestrictionsLike(CatalogRestrictions item) {
        return this.withNewCatalogRestrictionsLike(Optional.ofNullable(this.buildCatalogRestrictions()).orElse(item));
    }

    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)((Object)this);
    }

    public boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    public String getRelistBehavior() {
        return this.relistBehavior;
    }

    public A withRelistBehavior(String relistBehavior) {
        this.relistBehavior = relistBehavior;
        return (A)((Object)this);
    }

    public boolean hasRelistBehavior() {
        return this.relistBehavior != null;
    }

    public Duration getRelistDuration() {
        return this.relistDuration;
    }

    public A withRelistDuration(Duration relistDuration) {
        this.relistDuration = relistDuration;
        return (A)((Object)this);
    }

    public boolean hasRelistDuration() {
        return this.relistDuration != null;
    }

    public Long getRelistRequests() {
        return this.relistRequests;
    }

    public A withRelistRequests(Long relistRequests) {
        this.relistRequests = relistRequests;
        return (A)((Object)this);
    }

    public boolean hasRelistRequests() {
        return this.relistRequests != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterServiceBrokerSpecFluent that = (ClusterServiceBrokerSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.authInfo, (Object)that.authInfo)) {
            return false;
        }
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals((Object)this.catalogRestrictions, (Object)that.catalogRestrictions)) {
            return false;
        }
        if (!Objects.equals(this.insecureSkipTLSVerify, that.insecureSkipTLSVerify)) {
            return false;
        }
        if (!Objects.equals(this.relistBehavior, that.relistBehavior)) {
            return false;
        }
        if (!Objects.equals(this.relistDuration, that.relistDuration)) {
            return false;
        }
        if (!Objects.equals(this.relistRequests, that.relistRequests)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authInfo, this.caBundle, this.catalogRestrictions, this.insecureSkipTLSVerify, this.relistBehavior, this.relistDuration, this.relistRequests, this.url, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authInfo != null) {
            sb.append("authInfo:");
            sb.append((Object)((Object)this.authInfo) + ",");
        }
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle + ",");
        }
        if (this.catalogRestrictions != null) {
            sb.append("catalogRestrictions:");
            sb.append((Object)((Object)this.catalogRestrictions) + ",");
        }
        if (this.insecureSkipTLSVerify != null) {
            sb.append("insecureSkipTLSVerify:");
            sb.append(this.insecureSkipTLSVerify + ",");
        }
        if (this.relistBehavior != null) {
            sb.append("relistBehavior:");
            sb.append(this.relistBehavior + ",");
        }
        if (this.relistDuration != null) {
            sb.append("relistDuration:");
            sb.append(this.relistDuration + ",");
        }
        if (this.relistRequests != null) {
            sb.append("relistRequests:");
            sb.append(this.relistRequests + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withInsecureSkipTLSVerify() {
        return this.withInsecureSkipTLSVerify(true);
    }

    public class CatalogRestrictionsNested<N>
    extends CatalogRestrictionsFluent<CatalogRestrictionsNested<N>>
    implements Nested<N> {
        CatalogRestrictionsBuilder builder;

        CatalogRestrictionsNested(CatalogRestrictions item) {
            this.builder = new CatalogRestrictionsBuilder(this, item);
        }

        public N and() {
            return (N)ClusterServiceBrokerSpecFluent.this.withCatalogRestrictions(this.builder.build());
        }

        public N endCatalogRestrictions() {
            return this.and();
        }
    }

    public class AuthInfoNested<N>
    extends ClusterServiceBrokerAuthInfoFluent<AuthInfoNested<N>>
    implements Nested<N> {
        ClusterServiceBrokerAuthInfoBuilder builder;

        AuthInfoNested(ClusterServiceBrokerAuthInfo item) {
            this.builder = new ClusterServiceBrokerAuthInfoBuilder(this, item);
        }

        public N and() {
            return (N)ClusterServiceBrokerSpecFluent.this.withAuthInfo(this.builder.build());
        }

        public N endAuthInfo() {
            return this.and();
        }
    }
}

