/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.servicecatalog.api.model.ClusterServicePlan;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanFluent;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanSpec;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanSpecBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanSpecFluentImpl;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanStatus;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanStatusBuilder;
import io.fabric8.servicecatalog.api.model.ClusterServicePlanStatusFluentImpl;
import java.util.Objects;

public class ClusterServicePlanFluentImpl<A extends ClusterServicePlanFluent<A>>
extends BaseFluent<A>
implements ClusterServicePlanFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ClusterServicePlanSpecBuilder spec;
    private ClusterServicePlanStatusBuilder status;

    public ClusterServicePlanFluentImpl() {
    }

    public ClusterServicePlanFluentImpl(ClusterServicePlan instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterServicePlanFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterServicePlanFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterServicePlanFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterServicePlanFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterServicePlanFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ClusterServicePlanSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ClusterServicePlanSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ClusterServicePlanSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ClusterServicePlanSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ClusterServicePlanFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ClusterServicePlanFluent.SpecNested<A> withNewSpecLike(ClusterServicePlanSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ClusterServicePlanFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ClusterServicePlanFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ClusterServicePlanSpecBuilder().build());
    }

    @Override
    public ClusterServicePlanFluent.SpecNested<A> editOrNewSpecLike(ClusterServicePlanSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ClusterServicePlanStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ClusterServicePlanStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ClusterServicePlanStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ClusterServicePlanStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(Boolean removedFromBrokerCatalog) {
        return this.withStatus(new ClusterServicePlanStatus(removedFromBrokerCatalog));
    }

    @Override
    public ClusterServicePlanFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ClusterServicePlanFluent.StatusNested<A> withNewStatusLike(ClusterServicePlanStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ClusterServicePlanFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ClusterServicePlanFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ClusterServicePlanStatusBuilder().build());
    }

    @Override
    public ClusterServicePlanFluent.StatusNested<A> editOrNewStatusLike(ClusterServicePlanStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterServicePlanFluentImpl that = (ClusterServicePlanFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends ClusterServicePlanStatusFluentImpl<ClusterServicePlanFluent.StatusNested<N>>
    implements ClusterServicePlanFluent.StatusNested<N>,
    Nested<N> {
        ClusterServicePlanStatusBuilder builder;

        StatusNestedImpl(ClusterServicePlanStatus item) {
            this.builder = new ClusterServicePlanStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ClusterServicePlanStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterServicePlanFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends ClusterServicePlanSpecFluentImpl<ClusterServicePlanFluent.SpecNested<N>>
    implements ClusterServicePlanFluent.SpecNested<N>,
    Nested<N> {
        ClusterServicePlanSpecBuilder builder;

        SpecNestedImpl(ClusterServicePlanSpec item) {
            this.builder = new ClusterServicePlanSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ClusterServicePlanSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterServicePlanFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterServicePlanFluent.MetadataNested<N>>
    implements ClusterServicePlanFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ClusterServicePlanFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

