/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.servicecatalog.api.model.ServiceInstance;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluent;
import io.fabric8.servicecatalog.api.model.ServiceInstanceFluentImpl;

public class ServiceInstanceBuilder
extends ServiceInstanceFluentImpl<ServiceInstanceBuilder>
implements VisitableBuilder<ServiceInstance, ServiceInstanceBuilder> {
    ServiceInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceInstanceBuilder() {
        this(false);
    }

    public ServiceInstanceBuilder(Boolean validationEnabled) {
        this(new ServiceInstance(), validationEnabled);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceInstance(), validationEnabled);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, ServiceInstance instance) {
        this(fluent, instance, false);
    }

    public ServiceInstanceBuilder(ServiceInstanceFluent<?> fluent, ServiceInstance instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstanceBuilder(ServiceInstance instance) {
        this(instance, (Boolean)false);
    }

    public ServiceInstanceBuilder(ServiceInstance instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceInstance build() {
        ServiceInstance buildable = new ServiceInstance(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }
}

